/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.RotorProperty;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IMaterialPartItem;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurbineRotorBehaviour
implements IMaterialPartItem,
ISubItemHandler {
    @Override
    public void fillItemCategory(Item item, CreativeModeTab category, NonNullList<ItemStack> items) {
        for (Material material : GTCEuAPI.materialManager.getRegisteredMaterials()) {
            ItemStack rotorStack;
            TurbineRotorBehaviour behavior;
            if (!material.shouldGenerateRecipesFor(TagPrefix.turbineBlade) || !material.hasProperty(PropertyKey.INGOT) || (behavior = TurbineRotorBehaviour.getBehaviour(rotorStack = new ItemStack((ItemLike)item))) == null) continue;
            behavior.setPartMaterial(rotorStack, material);
            items.add((Object)rotorStack);
        }
    }

    public int getRotorPower(ItemStack stack) {
        RotorProperty property = this.getPartMaterial(stack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : property.getPower();
    }

    public int getRotorEfficiency(ItemStack stack) {
        RotorProperty property = this.getPartMaterial(stack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : property.getEfficiency();
    }

    @Override
    public int getPartMaxDurability(ItemStack itemStack) {
        RotorProperty property = this.getPartMaterial(itemStack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1 : 800 * (int)Math.pow(property.getDurability(), 0.65);
    }

    public float getDamage(ItemStack itemStack) {
        RotorProperty property = this.getPartMaterial(itemStack).getProperty(PropertyKey.ROTOR);
        return property == null ? -1.0f : property.getDamage();
    }

    public int getRotorDurabilityPercent(ItemStack itemStack) {
        return 100 - 100 * this.getPartDamage(itemStack) / this.getPartMaxDurability(itemStack);
    }

    public void applyRotorDamage(ItemStack itemStack, int damageApplied) {
        int rotorDurability = this.getPartMaxDurability(itemStack);
        int resultDamage = this.getPartDamage(itemStack) + damageApplied;
        if (resultDamage >= rotorDurability) {
            itemStack.m_41774_(1);
        } else {
            this.setPartDamage(itemStack, resultDamage);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        IMaterialPartItem.super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.tool.tooltip.rotor.efficiency", (Object[])new Object[]{this.getRotorEfficiency(stack)}));
        tooltipComponents.add((Component)Component.m_237110_((String)"metaitem.tool.tooltip.rotor.power", (Object[])new Object[]{this.getRotorPower(stack)}));
    }

    @Nullable
    public static TurbineRotorBehaviour getBehaviour(@NotNull ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof IComponentItem) {
            IComponentItem componentItem = (IComponentItem)item;
            for (IItemComponent component : componentItem.getComponents()) {
                if (!(component instanceof TurbineRotorBehaviour)) continue;
                TurbineRotorBehaviour behaviour = (TurbineRotorBehaviour)component;
                return behaviour;
            }
        }
        return null;
    }
}

