/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorLogicSuite;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NightvisionGoggles
extends ArmorLogicSuite {
    public NightvisionGoggles(int energyPerUse, long capacity, int voltageTier, ArmorItem.Type slot) {
        super(energyPerUse, capacity, voltageTier, slot);
    }

    @Override
    public void onArmorTick(Level world, @NotNull Player player, @NotNull ItemStack itemStack) {
        int nightVisionTimer;
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item == null) {
            return;
        }
        CompoundTag data = itemStack.m_41784_();
        int toggleTimer = data.m_128441_("toggleTimer") ? data.m_128445_("toggleTimer") : 0;
        int n = nightVisionTimer = data.m_128441_("nightVisionTimer") ? data.m_128451_("nightVisionTimer") : 400;
        if (this.type == ArmorItem.Type.HELMET) {
            boolean nightVision;
            boolean bl = nightVision = data.m_128441_("nightVision") && data.m_128471_("nightVision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                nightVision = !nightVision;
                toggleTimer = 5;
                if (item.getCharge() < 4L) {
                    nightVision = false;
                    player.m_5661_((Component)Component.m_237115_((String)"metaarmor.nms.nightvision.error"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)("metaarmor.nms.nightvision." + (nightVision ? "enabled" : "disabled"))), true);
                }
            }
            if (nightVision) {
                player.m_21195_(MobEffects.f_19610_);
                if (nightVisionTimer <= 240) {
                    nightVisionTimer = 400;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 400, 0, true, false));
                    item.discharge(this.energyPerUse, this.tier, true, false, false);
                }
            } else {
                player.m_21195_(MobEffects.f_19611_);
            }
            data.m_128379_("nightVision", nightVision);
        }
        if (nightVisionTimer > 0) {
            --nightVisionTimer;
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.m_128405_("nightVisionTimer", nightVisionTimer);
        data.m_128344_("toggleTimer", (byte)toggleTimer);
    }

    public static void disableNightVision(@NotNull Level world, Player player, boolean sendMsg) {
        if (!world.f_46443_) {
            player.m_21195_(MobEffects.f_19611_);
            if (sendMsg) {
                player.m_5661_((Component)Component.m_237115_((String)"metaarmor.message.nightvision.disabled"), true);
            }
        }
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/nightvision_goggles.png");
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        if (this.type == ArmorItem.Type.HELMET) {
            CompoundTag nbtData = itemStack.m_41784_();
            boolean nv = nbtData.m_128471_("nightVision");
            if (nv) {
                lines.add((Component)Component.m_237115_((String)"metaarmor.message.nightvision.enabled"));
            } else {
                lines.add((Component)Component.m_237115_((String)"metaarmor.message.nightvision.disabled"));
            }
        }
    }
}

