/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ProspectingBehavior
implements IToolBehavior {
    public static final ProspectingBehavior INSTANCE = new ProspectingBehavior();

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        Item item = context.m_43722_().m_41720_();
        if (item instanceof IGTTool) {
            IGTTool tool = (IGTTool)item;
            int tier = tool.getTotalHarvestLevel(context.m_43722_());
            int depth = tool.getProspectingDepth();
            ProspectingBehavior.findOres(context.m_43725_(), context.m_8083_(), context.m_43719_(), depth).forEach(c -> {
                if (context.m_43723_() != null && context.m_43725_().m_5776_()) {
                    context.m_43723_().m_213846_((Component)c);
                }
            });
            return InteractionResult.SUCCESS;
        }
        return IToolBehavior.super.onItemUse(context);
    }

    private static List<MutableComponent> findOres(Level level, BlockPos pos, Direction direction, int depth) {
        HashSet<BlockState> foundBlocks = new HashSet<BlockState>();
        HashSet<Fluid> foundFluids = new HashSet<Fluid>();
        for (int i = 0; i < depth; ++i) {
            for (BlockPos position : ProspectingBehavior.getSurroundingBlocks(pos, direction)) {
                if (!level.m_6425_(position).m_76178_()) {
                    foundFluids.add(level.m_6425_(position).m_76152_());
                    continue;
                }
                foundBlocks.add(level.m_8055_(position));
            }
            if (direction.m_122434_().m_122479_()) {
                for (BlockPos position : ProspectingBehavior.getSurroundingBlocks(pos.m_7495_(), direction)) {
                    if (!level.m_6425_(position).m_76178_()) {
                        foundFluids.add(level.m_6425_(position).m_76152_());
                        continue;
                    }
                    foundBlocks.add(level.m_8055_(position));
                }
            }
            pos = pos.m_121945_(direction.m_122424_());
        }
        ArrayList<MutableComponent> out = new ArrayList<MutableComponent>();
        int cnt = 0;
        for (BlockState blockState : foundBlocks) {
            if (blockState.m_204336_(Tags.Blocks.ORES)) {
                out.add(Component.m_237110_((String)"item.gtceu.tool.behavior.prospecting.ore", (Object[])new Object[]{blockState.m_60734_().m_49954_()}));
                continue;
            }
            if (blockState.m_60795_()) {
                out.add(Component.m_237115_((String)"item.gtceu.tool.behavior.prospecting.air"));
                continue;
            }
            ++cnt;
        }
        for (Fluid fluid : foundFluids) {
            if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
                out.add(Component.m_237115_((String)"item.gtceu.tool.behavior.prospecting.water"));
            }
            if (!fluid.m_6212_((Fluid)Fluids.f_76195_)) continue;
            out.add(Component.m_237115_((String)"item.gtceu.tool.behavior.prospecting.lava"));
        }
        if (cnt >= 2) {
            out.add(Component.m_237115_((String)"item.gtceu.tool.behavior.prospecting.changing"));
        }
        return out;
    }

    private static List<BlockPos> getSurroundingBlocks(BlockPos pos, Direction dir) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        for (Direction direction : Direction.values()) {
            if (direction.m_122434_() == dir.m_122434_()) continue;
            out.add(pos.m_121945_(direction));
        }
        out.add(pos);
        return out;
    }
}

