/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class CreativeTankMachine
extends QuantumTankMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CreativeTankMachine.class, QuantumTankMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DropSaved
    private int mBPerCycle = 1000;
    @Persisted
    @DropSaved
    private int ticksPerCycle = 1;

    public CreativeTankMachine(IMachineBlockEntity holder) {
        super(holder, 14, 1L, new Object[0]);
    }

    @Override
    protected QuantumTankMachine.FluidCache createCacheFluidHandler(Object ... args) {
        return new InfiniteCache((MetaMachine)this);
    }

    @Override
    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % (long)this.ticksPerCycle == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.cache.exportToNearby(this.getOutputFacingFluids());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public long getStoredAmount() {
        return (long)Math.ceil(1.0 * (double)this.mBPerCycle / (double)this.ticksPerCycle);
    }

    private InteractionResult updateStored(FluidStack fluid) {
        this.stored = new FluidStack(fluid, 1000);
        this.onFluidChanged();
        return InteractionResult.SUCCESS;
    }

    private void setTicksPerCycle(String value) {
        if (value.isEmpty()) {
            return;
        }
        this.ticksPerCycle = Integer.parseInt(value);
        this.onFluidChanged();
    }

    private void setmBPerCycle(String value) {
        if (value.isEmpty()) {
            return;
        }
        this.mBPerCycle = Integer.parseInt(value);
        this.onFluidChanged();
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (hit.m_82434_() == this.getFrontFacing() && !this.isRemote()) {
            if (heldItem.m_41619_()) {
                if (player.m_6047_() && !this.stored.isEmpty()) {
                    return this.updateStored(FluidStack.EMPTY);
                }
                return InteractionResult.PASS;
            }
            if (this.stored.isEmpty()) {
                return FluidUtil.getFluidContained((ItemStack)heldItem).map(this::updateStored).orElse(InteractionResult.PASS);
            }
            CustomFluidTank source = new CustomFluidTank(new FluidStack(this.stored, Integer.MAX_VALUE));
            ItemStack result = FluidUtil.tryFillContainer((ItemStack)heldItem, (IFluidHandler)source, (int)Integer.MAX_VALUE, (Player)player, (boolean)true).getResult();
            if (!result.m_41619_() && heldItem.m_41613_() > 1) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
                result = heldItem.m_41777_();
                result.m_41774_(1);
            }
            if (!result.m_41619_()) {
                player.m_21008_(hand, result);
                return InteractionResult.SUCCESS;
            }
            return FluidUtil.getFluidContained((ItemStack)heldItem).map(this::updateStored).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    public WidgetGroup createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 131);
        group.addWidget((Widget)new PhantomFluidWidget((IFluidHandler)this.cache, 0, 36, 6, 18, 18, this::getStored, this::updateStored).setShowAmount(false).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        group.addWidget((Widget)new LabelWidget(7, 9, "gtceu.creative.tank.fluid"));
        group.addWidget((Widget)new ImageWidget(7, 45, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 47, 152, 10, () -> String.valueOf(this.mBPerCycle), this::setmBPerCycle).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 28, "gtceu.creative.tank.mbpc"));
        group.addWidget((Widget)new ImageWidget(7, 82, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 84, 152, 10, () -> String.valueOf(this.ticksPerCycle), this::setTicksPerCycle).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 65, "gtceu.creative.tank.tpc"));
        group.addWidget((Widget)new SwitchWidget(7, 101, 162, 20, (clickData, value) -> this.setWorkingEnabled((boolean)value)).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.off")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.on")})).setPressed(this.isWorkingEnabled()));
        return group;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public int getMBPerCycle() {
        return this.mBPerCycle;
    }

    @Generated
    public int getTicksPerCycle() {
        return this.ticksPerCycle;
    }

    private class InfiniteCache
    extends QuantumTankMachine.FluidCache {
        public InfiniteCache(MetaMachine holder) {
            super(CreativeTankMachine.this, holder);
        }

        @Override
        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return CreativeTankMachine.this.stored;
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!CreativeTankMachine.this.stored.isEmpty() && CreativeTankMachine.this.stored.isFluidEqual(resource)) {
                return resource.getAmount();
            }
            return 0;
        }

        @Override
        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!CreativeTankMachine.this.stored.isEmpty()) {
                return new FluidStack(CreativeTankMachine.this.stored, CreativeTankMachine.this.mBPerCycle);
            }
            return FluidStack.EMPTY;
        }

        @Override
        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!CreativeTankMachine.this.stored.isEmpty() && CreativeTankMachine.this.stored.isFluidEqual(resource)) {
                return new FluidStack(resource, CreativeTankMachine.this.mBPerCycle);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return true;
        }

        @Override
        public int getTankCapacity(int tank) {
            return 1000;
        }
    }
}

