/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PhantomSlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class QuantumChestMachine
extends TieredMachine
implements IAutoOutputItem,
IInteractedMachine,
IControllable,
IDropSaveMachine,
IFancyUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(QuantumChestMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    public static final Object2LongOpenHashMap<UUID> INTERACTION_LOGGER = new Object2LongOpenHashMap();
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    protected boolean allowInputFromOutputSideItems;
    @Persisted
    private boolean isVoiding;
    private final long maxAmount;
    protected final ItemCache cache;
    @DescSynced
    private final CustomItemStackHandler lockedItem;
    @DescSynced
    protected ItemStack stored = ItemStack.f_41583_;
    @DescSynced
    protected long storedAmount = 0L;
    @Nullable
    protected TickableSubscription autoOutputSubs;

    public QuantumChestMachine(IMachineBlockEntity holder, int tier, long maxAmount, Object ... args) {
        super(holder, tier);
        this.outputFacingItems = this.getFrontFacing().m_122424_();
        this.maxAmount = maxAmount;
        this.cache = this.createCacheItemHandler(args);
        this.lockedItem = new CustomItemStackHandler();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected ItemCache createCacheItemHandler(Object ... args) {
        return new ItemCache(this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
    }

    protected void onItemChanged() {
        if (!this.isRemote()) {
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public boolean saveBreak() {
        return !this.stored.m_41619_();
    }

    @Override
    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        if (!forDrop) {
            tag.m_128365_("lockedItem", (Tag)this.lockedItem.serializeNBT());
        }
        tag.m_128365_("stored", (Tag)this.stored.serializeNBT());
        tag.m_128356_("storedAmount", this.storedAmount);
    }

    @Override
    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        this.lockedItem.deserializeNBT(tag.m_128469_("lockedItem"));
        this.stored = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stored"));
        this.storedAmount = tag.m_128454_("storedAmount");
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        if (side == this.getFrontFacing()) {
            return null;
        }
        return super.getItemHandlerCap(side, useCoverCapability);
    }

    @Override
    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        if (side == this.getFrontFacing()) {
            return null;
        }
        return super.getFluidHandlerCap(side, useCoverCapability);
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingItems(@Nullable Direction outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isAutoOutputItems();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.setAutoOutputItems(isWorkingAllowed);
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingItems();
        if (this.isAutoOutputItems() && !this.stored.m_41619_() && outputFacing != null && GTTransferUtils.hasAdjacentItemHandler(this.getLevel(), this.getPos(), outputFacing)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.cache.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.outputFacingItems) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.m_82434_() == this.getFrontFacing() && !this.isRemote()) {
            Vec3 hitVector;
            AABB aabb = new AABB(hit.m_82425_()).m_82406_(0.12);
            if (!aabb.m_82390_(hitVector = hit.m_82450_().m_231075_(this.getFrontFacing(), -0.5))) {
                return InteractionResult.PASS;
            }
            ItemStack held = player.m_21205_();
            if (!held.m_41619_() && this.cache.canInsert(held)) {
                ItemStack remaining = this.cache.insertItem(0, held, false);
                player.m_21008_(InteractionHand.MAIN_HAND, remaining);
                return InteractionResult.SUCCESS;
            }
            if (QuantumChestMachine.isDoubleHit(player.m_20148_())) {
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (stack.m_41619_() || !this.cache.canInsert(stack)) continue;
                    stack.m_41764_(this.cache.insertItem(0, stack, false).m_41613_());
                }
            }
            INTERACTION_LOGGER.put((Object)player.m_20148_(), System.currentTimeMillis());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean isDoubleHit(UUID uuid) {
        return System.currentTimeMillis() - INTERACTION_LOGGER.getLong((Object)uuid) < 300L;
    }

    @Override
    public boolean onLeftClick(Player player, Level world, InteractionHand hand, BlockPos pos, Direction direction) {
        if (direction == this.getFrontFacing() && !this.isRemote()) {
            ItemStack drained;
            if (GTToolType.WRENCH.matchTags.stream().anyMatch(arg_0 -> ((ItemStack)player.m_21120_(hand)).m_204117_(arg_0))) {
                return false;
            }
            if (!(this.stored.m_41619_() || (drained = this.cache.extractItem(0, player.m_6144_() ? this.stored.m_41741_() : 1, false)).m_41619_() || player.m_36356_(drained))) {
                Block.m_152435_((Level)world, (BlockPos)this.getPos(), (Direction)this.getFrontFacing(), (ItemStack)drained);
            }
        }
        return IInteractedMachine.super.onLeftClick(player, world, hand, pos, direction);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.m_6144_() && !this.isRemote()) {
            ItemStack tool = playerIn.m_21120_(hand);
            if (tool.m_41773_() >= tool.m_41776_()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            if (gridSide != this.getOutputFacingItems()) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            return InteractionResult.m_19078_((boolean)playerIn.m_9236_().f_46443_);
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            if (gridSide == this.getOutputFacingItems()) {
                if (this.isAllowInputFromOutputSideItems()) {
                    this.setAllowInputFromOutputSideItems(false);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.disallow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.chest.item")));
                } else {
                    this.setAllowInputFromOutputSideItems(true);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.allow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.chest.item")));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    public boolean isLocked() {
        return !this.lockedItem.getStackInSlot(0).m_41619_();
    }

    protected void setLocked(boolean locked) {
        if (!this.stored.m_41619_() && locked) {
            ItemStack copied = this.stored.m_255036_(1);
            this.lockedItem.setStackInSlot(0, copied);
        } else if (!locked) {
            this.lockedItem.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    public ItemStack getLockedItem() {
        return this.lockedItem.getStackInSlot(0);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 109, 63);
        CustomItemStackHandler importItems = this.createImportItems();
        group.addWidget((Widget)new ImageWidget(4, 4, 81, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.machine.quantum_chest.items_stored")).addWidget((Widget)new LabelWidget(8, 18, () -> FormattingUtil.formatNumbers(this.storedAmount)).setTextColor(-1).setDropShadow(true)).addWidget((Widget)new SlotWidget((IItemHandlerModifiable)importItems, 0, 87, 5, false, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY}))).addWidget((Widget)new SlotWidget(this.cache, 0, 87, 23, false, false).setItemHook(s -> s.m_255036_((int)Math.min(this.storedAmount, (long)s.m_41741_()))).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT)).addWidget((Widget)new ButtonWidget(87, 42, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, Icons.DOWN.scale(0.7f)}), cd -> {
            ItemStack extracted;
            if (!(cd.isRemote || this.stored.m_41619_() || group.getGui().entityPlayer.m_36356_(extracted = this.cache.extractItem(0, (int)Math.min(this.storedAmount, (long)this.stored.m_41741_()), false)))) {
                Block.m_49840_((Level)group.getGui().entityPlayer.m_9236_(), (BlockPos)group.getGui().entityPlayer.m_20097_(), (ItemStack)extracted);
            }
        })).addWidget((Widget)new PhantomSlotWidget((IItemHandlerModifiable)this.lockedItem, 0, 58, 41, stack -> this.stored.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.stored)).setMaxStackSize(1)).addWidget((Widget)new ToggleButtonWidget(4, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_ITEM_OUTPUT, this::isAutoOutputItems, this::setAutoOutputItems).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_auto_output.tooltip")).addWidget((Widget)new ToggleButtonWidget(22, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_lock.tooltip")).addWidget((Widget)new ToggleButtonWidget(40, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_VOID, () -> this.isVoiding, b -> {
            this.isVoiding = b;
        }).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_voiding_partial.tooltip"));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @NotNull
    private CustomItemStackHandler createImportItems() {
        CustomItemStackHandler importItems = new CustomItemStackHandler();
        importItems.setFilter(this.cache::canInsert);
        importItems.setOnContentsChanged(() -> {
            ItemStack item = importItems.getStackInSlot(0).m_41777_();
            if (!item.m_41619_()) {
                importItems.setStackInSlot(0, ItemStack.f_41583_);
                importItems.onContentsChanged(0);
                this.cache.insertItem(0, item.m_41777_(), false);
            }
        });
        return importItems;
    }

    @Override
    @Nullable
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.m_6144_() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (side == this.getOutputFacingItems()) {
                return GuiTextures.TOOL_ALLOW_INPUT;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET) && side == this.getFrontFacing()) {
            return null;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    @Generated
    public Direction getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    @Generated
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    @Generated
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    @Override
    @Generated
    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    @Generated
    public ItemStack getStored() {
        return this.stored;
    }

    @Generated
    public long getStoredAmount() {
        return this.storedAmount;
    }

    protected class ItemCache
    extends MachineTrait
    implements IItemHandlerModifiable {
        private final Predicate<ItemStack> filter;

        public ItemCache(MetaMachine holder) {
            super(holder);
            this.filter = i -> !QuantumChestMachine.this.isLocked() || ItemStack.m_150942_((ItemStack)i, (ItemStack)QuantumChestMachine.this.getLockedItem());
        }

        public void setStackInSlot(int index, ItemStack stack) {
            QuantumChestMachine.this.stored = stack.m_255036_(1);
            QuantumChestMachine.this.storedAmount = stack.m_41613_();
            QuantumChestMachine.this.onItemChanged();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return QuantumChestMachine.this.stored.m_255036_(GTMath.saturatedCast(QuantumChestMachine.this.storedAmount));
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            long free = QuantumChestMachine.this.isVoiding ? Long.MAX_VALUE : QuantumChestMachine.this.maxAmount - QuantumChestMachine.this.storedAmount;
            long canStore = 0L;
            if ((QuantumChestMachine.this.stored.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)QuantumChestMachine.this.stored, (ItemStack)stack)) && this.filter.test(stack)) {
                canStore = Math.min((long)stack.m_41613_(), free);
            }
            if (!simulate && canStore > 0L) {
                if (QuantumChestMachine.this.stored.m_41619_()) {
                    QuantumChestMachine.this.stored = stack.m_255036_(1);
                }
                QuantumChestMachine.this.storedAmount = Math.min(QuantumChestMachine.this.maxAmount, QuantumChestMachine.this.storedAmount + canStore);
                QuantumChestMachine.this.onItemChanged();
            }
            return stack.m_255036_((int)((long)stack.m_41613_() - canStore));
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (QuantumChestMachine.this.stored.m_41619_()) {
                return ItemStack.f_41583_;
            }
            long toExtract = Math.min(QuantumChestMachine.this.storedAmount, (long)amount);
            ItemStack copy = QuantumChestMachine.this.stored.m_255036_((int)toExtract);
            if (!simulate && toExtract > 0L) {
                QuantumChestMachine.this.storedAmount -= toExtract;
                if (QuantumChestMachine.this.storedAmount == 0L) {
                    QuantumChestMachine.this.stored = ItemStack.f_41583_;
                }
                QuantumChestMachine.this.onItemChanged();
            }
            return copy;
        }

        public int getSlotLimit(int slot) {
            return GTMath.saturatedCast(QuantumChestMachine.this.maxAmount);
        }

        public int getSlots() {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.filter.test(stack);
        }

        public void exportToNearby(Direction ... facings) {
            if (QuantumChestMachine.this.stored.m_41619_()) {
                return;
            }
            Level level = this.getMachine().getLevel();
            BlockPos pos = this.getMachine().getPos();
            for (Direction facing : facings) {
                Predicate<ItemStack> filter = this.getMachine().getItemCapFilter(facing, IO.OUT);
                GTTransferUtils.getAdjacentItemHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferItemsFiltered((IItemHandler)this, adj, filter));
            }
        }

        public boolean canInsert(ItemStack stack) {
            return this.filter.test(stack) && this.insertItem(0, stack, true).m_41613_() != stack.m_41613_();
        }

        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }
    }
}

