/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item.longdistance;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.common.machine.storage.LongDistanceEndpointMachine;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemPipeType;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LDItemEndpointMachine
extends LongDistanceEndpointMachine {
    public LDItemEndpointMachine(IMachineBlockEntity metaTileEntityId) {
        super(metaTileEntityId, LDItemPipeType.INSTANCE);
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        if (this.isRemote() || this.getIoType() != IO.IN || side != this.getFrontFacing()) {
            return null;
        }
        ILDEndpoint endpoint = this.getLink();
        if (endpoint == null) {
            return null;
        }
        return GTTransferUtils.getAdjacentItemHandler(this.getLevel(), endpoint.getPos(), endpoint.getOutputFacing()).map(ItemHandlerWrapper::new).orElse(null);
    }

    public static class ItemHandlerWrapper
    implements IItemHandlerModifiable {
        private final IItemHandler delegate;

        public ItemHandlerWrapper(IItemHandler delegate) {
            this.delegate = delegate;
        }

        public int getSlots() {
            return this.delegate.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.delegate.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.delegate.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.delegate.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.delegate.isItemValid(slot, stack);
        }

        public void setStackInSlot(int i, @NotNull ItemStack itemStack) {
            IItemHandler iItemHandler = this.delegate;
            if (iItemHandler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable modifiable = (IItemHandlerModifiable)iItemHandler;
                modifiable.setStackInSlot(i, itemStack);
            }
        }
    }
}

