/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKey;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.forge.GTClientFluidTypeExtensions;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.BlockBehaviourAccessor;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.Tags;

public class MixinHelpers {
    private static final VanillaBlockLoot BLOCK_LOOT = new VanillaBlockLoot();

    public static <T> void generateGTDynamicTags(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagMap, Registry<T> registry) {
        block9: {
            block10: {
                block8: {
                    if (registry != BuiltInRegistries.f_257033_) break block8;
                    ItemMaterialData.MATERIAL_ENTRY_ITEM_MAP.forEach((entry, itemLikes) -> {
                        if (itemLikes.isEmpty()) {
                            return;
                        }
                        Material material = entry.material();
                        if (material.isNull()) {
                            return;
                        }
                        ArrayList entries = itemLikes.stream().map(MixinHelpers::makeItemEntry).collect(MixinHelpers.toArrayList());
                        TagKey<Item>[] prefixTagKeys = entry.tagPrefix().getAllItemTags(material);
                        for (TagKey<Item> prefixTag : prefixTagKeys) {
                            tagMap.computeIfAbsent(prefixTag.f_203868_(), path -> new ArrayList()).addAll(entries);
                        }
                        for (TagKey tagKey : material.getItemTags()) {
                            tagMap.computeIfAbsent(tagKey.f_203868_(), path -> new ArrayList()).addAll(entries);
                        }
                        if (entry.tagPrefix() == TagPrefix.crushed && material.hasProperty(PropertyKey.ORE)) {
                            OreProperty ore = material.getProperty(PropertyKey.ORE);
                            Material material2 = (Material)ore.getWashedIn().first();
                            if (material2.isNull()) {
                                return;
                            }
                            ResourceLocation generalTag = CustomTags.CHEM_BATH_WASHABLE.f_203868_();
                            ResourceLocation specificTag = generalTag.m_266382_("/" + material2.getName());
                            tagMap.computeIfAbsent(generalTag, path -> new ArrayList()).addAll(entries);
                            tagMap.computeIfAbsent(specificTag, path -> new ArrayList()).addAll(entries);
                        }
                    });
                    GTMaterialItems.TOOL_ITEMS.rowMap().forEach((material, map) -> map.values().forEach(item -> {
                        if (item == null) {
                            return;
                        }
                        TagLoader.EntryWithSource entry = MixinHelpers.makeItemEntry((ItemLike)item);
                        for (TagKey<Item> tag : ((IGTTool)item.get()).getToolType().itemTags) {
                            tagMap.computeIfAbsent(tag.f_203868_(), path -> new ArrayList()).add(entry);
                        }
                    }));
                    GTMaterialItems.ARMOR_ITEMS.rowMap().forEach((material, map) -> map.forEach((type, item) -> {
                        if (item != null) {
                            TagLoader.EntryWithSource entry = new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)item.getId()), "GTCEu Custom Tags");
                            tagMap.computeIfAbsent(ItemTags.f_265942_.f_203868_(), $ -> new ArrayList()).add(entry);
                            tagMap.computeIfAbsent(switch (type) {
                                default -> throw new IncompatibleClassChangeError();
                                case ArmorItem.Type.HELMET -> Tags.Items.ARMORS_HELMETS.f_203868_();
                                case ArmorItem.Type.CHESTPLATE -> Tags.Items.ARMORS_CHESTPLATES.f_203868_();
                                case ArmorItem.Type.LEGGINGS -> Tags.Items.ARMORS_LEGGINGS.f_203868_();
                                case ArmorItem.Type.BOOTS -> Tags.Items.ARMORS_BOOTS.f_203868_();
                            }, $ -> new ArrayList()).add(entry);
                        }
                    }));
                    if (!GTCEu.Mods.isAE2Loaded()) {
                        return;
                    }
                    ResourceLocation p2pFluidAttunements = new ResourceLocation("ae2", "p2p_attunements/fluid_p2p_tunnel");
                    for (Material material2 : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                        FluidProperty property = material2.getProperty(PropertyKey.FLUID);
                        if (property == null) continue;
                        for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                            Fluid fluid = property.get(key);
                            if (fluid == null || fluid.m_6859_() == Items.f_41852_) continue;
                            TagLoader.EntryWithSource entry2 = MixinHelpers.makeItemEntry((ItemLike)fluid.m_6859_());
                            tagMap.computeIfAbsent(p2pFluidAttunements, path -> new ArrayList()).add(entry2);
                        }
                    }
                    break block9;
                }
                if (registry != BuiltInRegistries.f_256975_) break block10;
                ItemMaterialData.MATERIAL_ENTRY_BLOCK_MAP.forEach((entry, blocks) -> {
                    if (blocks.isEmpty()) {
                        return;
                    }
                    Material material = entry.material();
                    if (material.isNull()) {
                        return;
                    }
                    ArrayList entries = blocks.stream().map(MixinHelpers::makeBlockEntry).collect(MixinHelpers.toArrayList());
                    TagKey<Block>[] materialTags = entry.tagPrefix().getAllBlockTags(material);
                    for (TagKey<Block> materialTag : materialTags) {
                        tagMap.computeIfAbsent(materialTag.f_203868_(), path -> new ArrayList()).addAll(entries);
                    }
                    if (!entry.isIgnored() && !entry.tagPrefix().miningToolTag().isEmpty()) {
                        tagMap.computeIfAbsent(CustomTags.TOOL_TIERS[material.getBlockHarvestLevel()].f_203868_(), path -> new ArrayList()).addAll(entries);
                        if (material.hasProperty(PropertyKey.WOOD)) {
                            if (entry.tagPrefix().miningToolTag().contains(CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH)) {
                                tagMap.computeIfAbsent(CustomTags.MINEABLE_WITH_WRENCH.f_203868_(), path -> new ArrayList()).addAll(entries);
                                if (!ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) {
                                    tagMap.computeIfAbsent(BlockTags.f_144280_.f_203868_(), path -> new ArrayList()).addAll(entries);
                                }
                            } else {
                                tagMap.computeIfAbsent(BlockTags.f_144280_.f_203868_(), path -> new ArrayList()).addAll(entries);
                            }
                        } else {
                            for (TagKey tagKey : entry.tagPrefix().miningToolTag()) {
                                tagMap.computeIfAbsent(tagKey.f_203868_(), path -> new ArrayList()).addAll(entries);
                            }
                        }
                    }
                });
                GTRegistries.MACHINES.forEach(machine -> tagMap.computeIfAbsent(CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH.f_203868_(), path -> new ArrayList()).add(MixinHelpers.makeBlockEntry(machine.getBlock())));
                if (ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) break block9;
                List tagList = tagMap.computeIfAbsent(BlockTags.f_144282_.f_203868_(), path -> new ArrayList());
                tagList.add(MixinHelpers.makeTagEntry(CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH));
                tagList.add(MixinHelpers.makeTagEntry(CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WIRE_CUTTER));
                break block9;
            }
            if (registry == BuiltInRegistries.f_257020_) {
                for (Material material3 : GTCEuAPI.materialManager.getRegisteredMaterials()) {
                    FluidProperty property = material3.getProperty(PropertyKey.FLUID);
                    if (property == null) continue;
                    for (FluidStorageKey key : FluidStorageKey.allKeys()) {
                        FluidState state;
                        Fluid fluid = property.get(key);
                        if (fluid == null) continue;
                        ItemMaterialData.FLUID_MATERIAL.put(fluid, material3);
                        TagLoader.EntryWithSource entry3 = MixinHelpers.makeFluidEntry(fluid);
                        ResourceLocation fluidIdTag = fluid.m_205069_().m_205785_().m_135782_();
                        fluidIdTag = new ResourceLocation("forge", fluidIdTag.m_135815_());
                        tagMap.computeIfAbsent(fluidIdTag, path -> new ArrayList()).add(entry3);
                        if (fluid instanceof GTFluid) {
                            GTFluid gtFluid = (GTFluid)fluid;
                            state = gtFluid.getState();
                        } else {
                            state = key.getDefaultFluidState();
                        }
                        tagMap.computeIfAbsent(state.getTagKey().f_203868_(), path -> new ArrayList()).add(entry3);
                        if (key.getExtraTag() == null) continue;
                        tagMap.computeIfAbsent(key.getExtraTag().f_203868_(), path -> new ArrayList()).add(entry3);
                    }
                }
            }
        }
    }

    private static <T> Collector<T, ?, ArrayList<T>> toArrayList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static TagLoader.EntryWithSource makeItemEntry(Supplier<? extends Item> item) {
        return MixinHelpers.makeItemEntry((ItemLike)item.get());
    }

    public static TagLoader.EntryWithSource makeItemEntry(ItemLike item) {
        return MixinHelpers.makeElementEntry(item.m_5456_().m_204114_().m_205785_().m_135782_());
    }

    public static TagLoader.EntryWithSource makeBlockEntry(Supplier<? extends Block> block) {
        return MixinHelpers.makeBlockEntry(block.get());
    }

    public static TagLoader.EntryWithSource makeBlockEntry(Block block) {
        return MixinHelpers.makeElementEntry(block.m_204297_().m_205785_().m_135782_());
    }

    public static TagLoader.EntryWithSource makeFluidEntry(Fluid fluid) {
        return MixinHelpers.makeElementEntry(fluid.m_205069_().m_205785_().m_135782_());
    }

    public static TagLoader.EntryWithSource makeElementEntry(ResourceLocation id) {
        return new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)id), "GTCEu Custom Tags");
    }

    public static TagLoader.EntryWithSource makeTagEntry(TagKey<?> tag) {
        return new TagLoader.EntryWithSource(TagEntry.m_215949_((ResourceLocation)tag.f_203868_()), "GTCEu Custom Tags");
    }

    public static void generateGTDynamicLoot(Map<ResourceLocation, LootTable> lootTables) {
        GTMaterialBlocks.MATERIAL_BLOCKS.rowMap().forEach((prefix, map) -> {
            if (TagPrefix.ORES.containsKey(prefix)) {
                TagPrefix.OreType type = TagPrefix.ORES.get(prefix);
                map.forEach((material, blockEntry) -> {
                    ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
                    Block block = (Block)blockEntry.get();
                    ItemStack dropItem = ChemicalHelper.get(TagPrefix.rawOre, material);
                    if (dropItem.m_41619_()) {
                        dropItem = ChemicalHelper.get(TagPrefix.gem, material);
                    }
                    if (dropItem.m_41619_()) {
                        dropItem = ChemicalHelper.get(TagPrefix.dust, material);
                    }
                    int oreMultiplier = type.isDoubleDrops() ? 2 : 1;
                    LootTable.Builder builder = BlockLootSubProvider.m_247502_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)BLOCK_LOOT.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)dropItem.m_41720_()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)oreMultiplier))))));
                    LootPool.Builder pool = LootPool.m_79043_();
                    boolean isEmpty = true;
                    for (MaterialStack secondaryMaterial : prefix.secondaryMaterials()) {
                        if (!secondaryMaterial.material().hasProperty(PropertyKey.DUST)) continue;
                        ItemStack dustStack = ChemicalHelper.getGem(secondaryMaterial);
                        pool.m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)dustStack.m_41720_()).m_79080_(BlockLootSubProvider.f_244217_)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165011_((int)0, (int)2))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()));
                        isEmpty = false;
                    }
                    if (!isEmpty) {
                        builder.m_79161_(pool);
                    }
                    lootTables.put(lootTableId, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
                    ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
                });
            } else {
                MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map);
            }
        });
        GTMaterialBlocks.CABLE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTMaterialBlocks.FLUID_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTMaterialBlocks.ITEM_PIPE_BLOCKS.rowMap().forEach((prefix, map) -> MixinHelpers.addMaterialBlockLootTables(lootTables, prefix, map));
        GTMaterialBlocks.SURFACE_ROCK_BLOCKS.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
            LootTable.Builder builder = BLOCK_LOOT.m_245765_((ItemLike)ChemicalHelper.get(TagPrefix.dustTiny, material).m_41720_(), (NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f)).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_));
            lootTables.put(lootTableId, builder.m_79165_(LootContextParamSets.f_81421_).m_79167_());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
        });
        GTRegistries.MACHINES.forEach(machine -> {
            Block block = machine.getBlock();
            ResourceLocation id = machine.getId();
            ResourceLocation lootTableId = new ResourceLocation(id.m_135827_(), "blocks/" + id.m_135815_());
            ((BlockBehaviourAccessor)block).setDrops(lootTableId);
            lootTables.put(lootTableId, BLOCK_LOOT.m_247033_((ItemLike)block).m_79165_(LootContextParamSets.f_81421_).m_79167_());
        });
    }

    public static void addMaterialBlockLootTables(Map<ResourceLocation, LootTable> lootTables, TagPrefix prefix, Map<Material, ? extends BlockEntry<? extends Block>> map) {
        map.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
            lootTables.put(lootTableId, BLOCK_LOOT.m_247033_((ItemLike)blockEntry.get()).m_79165_(LootContextParamSets.f_81421_).m_79167_());
        });
    }

    public static void addFluidTexture(Material material, FluidStorage.FluidEntry value) {
        IClientFluidTypeExtensions extensions;
        if (value != null && (extensions = IClientFluidTypeExtensions.of((Fluid)value.getFluid().get())) instanceof GTClientFluidTypeExtensions) {
            GTClientFluidTypeExtensions gtExtensions = (GTClientFluidTypeExtensions)extensions;
            if (value.getBuilder() != null) {
                gtExtensions.setFlowingTexture(value.getBuilder().flowing());
                gtExtensions.setStillTexture(value.getBuilder().still());
            }
        }
    }
}

