/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class GTMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE = "com.gregtechceu.gtceu.core.mixins.";
    private static final Map<String, String> MOD_COMPAT_MIXINS = new HashMap<String, String>();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        for (Map.Entry<String, String> compatMod : MOD_COMPAT_MIXINS.entrySet()) {
            if (!mixinClassName.startsWith(compatMod.getValue())) continue;
            return GTMixinPlugin.isModLoaded(compatMod.getKey());
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static void addModCompatMixin(String modId) {
        MOD_COMPAT_MIXINS.put(modId, MIXIN_PACKAGE + modId);
    }

    private static boolean isModLoaded(String modId) {
        if (ModList.get() == null) {
            return LoadingModList.get().getModFileById(modId) != null;
        }
        return ModList.get().isLoaded(modId);
    }

    static {
        MOD_COMPAT_MIXINS.put("roughlyenoughitems", "com.gregtechceu.gtceu.core.mixins.rei");
        GTMixinPlugin.addModCompatMixin("emi");
        GTMixinPlugin.addModCompatMixin("jei");
        GTMixinPlugin.addModCompatMixin("top");
        GTMixinPlugin.addModCompatMixin("ftbchunks");
        GTMixinPlugin.addModCompatMixin("xaerominimap");
        GTMixinPlugin.addModCompatMixin("xaeroworldmap");
    }
}

