/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftingComponent {
    public static final Map<String, CraftingComponent> ALL_COMPONENTS = new Object2ReferenceOpenHashMap();
    public static final CraftingComponent EMPTY = CraftingComponent.of("empty", ItemStack.f_41583_);
    private final Object[] values = new Object[GTValues.V.length];
    @NotNull
    private Object fallback;

    protected CraftingComponent(@NotNull Object fallback) {
        this.checkType(fallback);
        this.fallback = fallback;
    }

    public static CraftingComponent of(@NotNull String id, @NotNull Object fallback) {
        CraftingComponent existing = ALL_COMPONENTS.get(id);
        if (existing != null) {
            GTCEu.LOGGER.error("Duplicate crafting component id: {}, check components", (Object)id);
            return existing;
        }
        CraftingComponent ret = new CraftingComponent(fallback);
        ALL_COMPONENTS.put(id, ret);
        return ret;
    }

    public static CraftingComponent of(@NotNull String id, @NotNull TagPrefix prefix, @NotNull Material material) {
        return CraftingComponent.of(id, new MaterialEntry(prefix, material));
    }

    @NotNull
    public Object get(int tier) {
        if (this == EMPTY) {
            return ItemStack.f_41583_;
        }
        if (tier < 0 || tier >= this.values.length) {
            throw new IllegalArgumentException("Tier out of range of ULV-MAX, tier: " + tier);
        }
        Object val = this.values[tier];
        return val == null ? this.fallback : val;
    }

    @NotNull
    public CraftingComponent add(int tier, @NotNull Object value) {
        if (this == EMPTY) {
            return this;
        }
        this.checkType(value);
        this.values[tier] = value;
        return this;
    }

    @NotNull
    public CraftingComponent add(int tier, @NotNull TagPrefix prefix, @NotNull Material material) {
        return this.add(tier, new MaterialEntry(prefix, material));
    }

    public void remove(int tier) {
        if (this == EMPTY) {
            return;
        }
        if (tier < 0 || tier >= this.values.length) {
            throw new IllegalArgumentException("Tier out of range of ULV-MAX, tier: " + tier);
        }
        this.values[tier] = null;
    }

    private void checkType(@NotNull Object o) {
        if (o instanceof TagKey) {
            TagKey tag = (TagKey)o;
            if (!tag.m_207645_(BuiltInRegistries.f_257033_.m_123023_())) {
                throw new IllegalArgumentException("TagKey must be of type TagKey<Item>");
            }
        } else if (!(o instanceof ItemStack) && !(o instanceof MaterialEntry)) {
            throw new IllegalArgumentException("Object is not of type ItemStack, MaterialEntry or TagKey<Item>");
        }
    }

    public static CraftingComponent get(String id) {
        if (!ALL_COMPONENTS.containsKey(id)) {
            GTCEu.LOGGER.error("No such crafting component: {}", (Object)id);
            return EMPTY;
        }
        return ALL_COMPONENTS.get(id);
    }

    @Generated
    public void setFallback(@NotNull Object fallback) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        this.fallback = fallback;
    }
}

