/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class DecorationRecipes {
    private static final String[] OXIDATION_STAGES = new String[]{"raw", "exposed", "weathered", "oxidized"};

    private DecorationRecipes() {
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        DecorationRecipes.assemblerRecipes(provider);
        DecorationRecipes.dyeRecipes(provider);
        DecorationRecipes.copperOxidationRecipes(provider);
    }

    private static void assemblerRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("metal_sheet_white").inputItems(TagPrefix.block, GTMaterials.Concrete, 5).inputItems(TagPrefix.plate, GTMaterials.Iron, 2).circuitMeta(8).outputItems((Supplier)GTBlocks.METAL_SHEETS.get(DyeColor.WHITE), 32).EUt(4L).duration(20).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("large_metal_sheet_white").inputItems(TagPrefix.block, GTMaterials.Concrete, 5).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(9).outputItems((Supplier)GTBlocks.LARGE_METAL_SHEETS.get(DyeColor.WHITE), 32).EUt(4L).duration(20).addMaterialInfo(true).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("studs_black").inputItems(TagPrefix.block, GTMaterials.Concrete, 3).inputItems(TagPrefix.plate, GTMaterials.Rubber, 3).circuitMeta(8).outputItems((Supplier)GTBlocks.STUDS.get(DyeColor.BLACK), 32).EUt(4L).duration(20).addMaterialInfo(true).save(provider);
    }

    private static void dyeRecipes(Consumer<FinishedRecipe> provider) {
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            DyeColor color = DyeColor.values()[i];
            String colorName = color.m_41065_();
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("metal_sheet_%s".formatted(colorName)).inputItems(GTBlocks.METAL_SHEETS.get(DyeColor.WHITE).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.METAL_SHEETS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("large_metal_sheet_%s".formatted(colorName)).inputItems(GTBlocks.LARGE_METAL_SHEETS.get(DyeColor.WHITE).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.LARGE_METAL_SHEETS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("studs_%s".formatted(colorName)).inputItems(GTBlocks.STUDS.get(DyeColor.BLACK).asStack()).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(9)).outputItems((Supplier)GTBlocks.STUDS.get(color)).EUt(2L).duration(10).category(GTRecipeCategories.CHEM_DYES).save(provider);
        }
    }

    private static void copperOxidationRecipes(Consumer<FinishedRecipe> provider) {
        DecorationRecipes.registerOxidationChain(provider, "copper_block", Items.f_151000_, Items.f_151001_, Items.f_151002_, Items.f_151003_);
        DecorationRecipes.registerOxidationChain(provider, "cut_copper", Items.f_151004_, Items.f_151005_, Items.f_151006_, Items.f_151007_);
        DecorationRecipes.registerOxidationChain(provider, "cut_copper_stairs", Items.f_151008_, Items.f_150970_, Items.f_150971_, Items.f_150972_);
        DecorationRecipes.registerOxidationChain(provider, "cut_copper_slab", Items.f_150973_, Items.f_150974_, Items.f_150975_, Items.f_150976_);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_copper_block").inputItems(Items.f_151000_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150977_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_exposed_copper").inputItems(Items.f_151001_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150978_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_weathered_copper").inputItems(Items.f_151002_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150979_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_oxidized_copper").inputItems(Items.f_151003_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150980_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_cut_copper").inputItems(Items.f_151004_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150981_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_exposed_cut_copper").inputItems(Items.f_151005_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150982_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_weathered_cut_copper").inputItems(Items.f_151006_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150983_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_oxidized_cut_copper").inputItems(Items.f_151007_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150984_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_cut_copper_stairs").inputItems(Items.f_151008_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150985_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_exposed_cut_copper_stairs").inputItems(Items.f_150970_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150986_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_weathered_cut_copper_stairs").inputItems(Items.f_150971_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150987_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_oxidized_cut_copper_stairs").inputItems(Items.f_150972_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150988_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_cut_copper_slab").inputItems(Items.f_150973_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150989_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_exposed_cut_copper_slab").inputItems(Items.f_150974_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150990_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_weathered_cut_copper_slab").inputItems(Items.f_150975_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150991_).EUt(GTValues.VA[0]).duration(10).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("waxing_oxidized_cut_copper_slab").inputItems(Items.f_150976_).inputFluids(GTMaterials.Wax, 72).outputItems(Items.f_150992_).EUt(GTValues.VA[0]).duration(10).save(provider);
    }

    private static void registerOxidationChain(Consumer<FinishedRecipe> provider, String name, Item ... items) {
        for (int i = 0; i < items.length - 1; ++i) {
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("%s_to_%s_%s_oxidation".formatted(OXIDATION_STAGES[i], OXIDATION_STAGES[i + 1], name)).inputItems(items[i]).inputFluids(GTMaterials.Oxygen, 100).outputItems(items[i + 1]).EUt(GTValues.VA[0]).duration(10).save(provider);
        }
    }
}

