/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.integration.jade.provider.BlockInfoProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class SteamBoilerBlockProvider
extends BlockInfoProvider<SteamBoilerMachine> {
    public SteamBoilerBlockProvider() {
        super(GTCEu.id("steam_boiler_info"));
    }

    @Override
    @Nullable
    protected SteamBoilerMachine getCapability(Level level, BlockPos blockPos) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof SteamBoilerMachine) {
            SteamBoilerMachine steamBoilerMachine = (SteamBoilerMachine)metaMachine;
            return steamBoilerMachine;
        }
        return null;
    }

    @Override
    protected void write(CompoundTag data, SteamBoilerMachine capability, BlockAccessor block) {
        data.m_128379_("isBurning", capability.getRecipeLogic().isWorking());
        data.m_128379_("hasWater", !capability.isHasNoWater());
        data.m_128356_("steamProduction", capability.getTotalSteamOutput());
        data.m_128405_("currentTemperature", capability.getCurrentTemperature());
        data.m_128405_("maxTemperature", capability.getMaxTemperature());
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        MutableComponent extra;
        boolean makingSteam;
        boolean isBurning = capData.m_128471_("isBurning");
        boolean hasWater = capData.m_128471_("hasWater");
        long production = capData.m_128454_("steamProduction");
        int temperature = capData.m_128451_("currentTemperature");
        int maxTemperature = capData.m_128451_("maxTemperature");
        boolean bl = makingSteam = hasWater && temperature >= 100;
        MutableComponent root = isBurning && temperature < maxTemperature ? Component.m_237115_((String)"gtceu.machine.boiler.info.heating.up") : (!isBurning && temperature > 0 ? Component.m_237115_((String)"gtceu.machine.boiler.info.cooling.down") : null);
        if (makingSteam) {
            extra = Component.m_237110_((String)"gtceu.machine.boiler.info.production.data", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumbers(production / 10L)).m_130940_(ChatFormatting.GREEN)});
            if (root != null) {
                extra = Component.m_237113_((String)" | ").m_7220_((Component)extra);
            }
        } else {
            extra = temperature > 0 && temperature < 100 ? Component.m_237113_((String)String.format(" (%s%%)", temperature)).m_130940_(isBurning ? ChatFormatting.RED : ChatFormatting.BLUE) : null;
        }
        if (root != null && extra != null) {
            tooltip.add((Component)root.m_7220_(extra));
        } else if (root != null) {
            tooltip.add((Component)root);
        } else if (extra != null) {
            tooltip.add(extra);
        }
    }
}

