/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe;

import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapedRecipeSchema;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.TinyMap;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;

public interface GTShapedRecipeSchema {
    public static final RecipeSchema SCHEMA = new RecipeSchema(ShapedRecipeJS.class, ShapedRecipeJS::new, new RecipeKey[]{ShapedRecipeSchema.RESULT, ShapedRecipeSchema.PATTERN, ShapedRecipeSchema.KEY}).constructor(new RecipeKey[]{ShapedRecipeSchema.RESULT, ShapedRecipeSchema.PATTERN, ShapedRecipeSchema.KEY}).uniqueOutputId(ShapedRecipeSchema.RESULT);

    public static class ShapedRecipeJS
    extends RecipeJS {
        protected boolean addMaterialInfo = false;

        public ShapedRecipeJS addMaterialInfo() {
            this.addMaterialInfo = true;
            return this;
        }

        @HideFromJS
        public List<IngredientAction> getIngredientActions() {
            if (this.recipeIngredientActions == null) {
                return Collections.emptyList();
            }
            return this.recipeIngredientActions;
        }

        public void afterLoaded() {
            super.afterLoaded();
            String[] pattern = (String[])this.getValue(ShapedRecipeSchema.PATTERN);
            TinyMap key = (TinyMap)this.getValue(ShapedRecipeSchema.KEY);
            if (pattern.length == 0) {
                throw new RecipeExceptionJS("Pattern is empty!");
            }
            if (key.isEmpty()) {
                throw new RecipeExceptionJS("Key map is empty!");
            }
            CharSet tools = ToolHelper.getToolSymbols();
            CharArraySet addedTools = new CharArraySet(9);
            CharArrayList airs = new CharArrayList(1);
            ArrayList<TinyMap.Entry> keyEntries = new ArrayList<TinyMap.Entry>(Arrays.asList(key.entries()));
            Iterator<TinyMap.Entry> it = keyEntries.iterator();
            while (it.hasNext()) {
                TinyMap.Entry entry = it.next();
                char entryKey = ((Character)entry.key()).charValue();
                if (entry.value() == null || ((InputItem)entry.value()).isEmpty()) {
                    airs.add(entryKey);
                    it.remove();
                    continue;
                }
                if (!tools.contains(entryKey)) continue;
                ConsoleJS.SERVER.warn((Object)("Symbol {" + entryKey + "} set as key in tooled recipe - overriding"));
                it.remove();
            }
            for (int i = 0; i < pattern.length; ++i) {
                CharListIterator it2 = airs.iterator();
                while (it2.hasNext()) {
                    pattern[i] = pattern[i].replace(it2.nextChar(), ' ');
                }
                for (char c : pattern[i].toCharArray()) {
                    if (!tools.contains(c) || addedTools.contains(c)) continue;
                    GTToolType tool = ToolHelper.getToolFromSymbol(c);
                    keyEntries.add(new TinyMap.Entry((Object)Character.valueOf(c), (Object)InputItem.of(tool.craftingTags.get(0))));
                    addedTools.add(c);
                }
            }
            if (!airs.isEmpty() || !addedTools.isEmpty()) {
                this.setValue(ShapedRecipeSchema.PATTERN, pattern);
                this.setValue(ShapedRecipeSchema.KEY, new TinyMap(keyEntries));
            }
        }

        @Generated
        public boolean isAddMaterialInfo() {
            return this.addMaterialInfo;
        }
    }
}

