/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.rei.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeDisplay;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.rei.IGui2Renderer;
import com.lowdragmc.lowdraglib.rei.ModularUIDisplayCategory;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.function.Function;
import lombok.Generated;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GTRecipeREICategory
extends ModularUIDisplayCategory<GTRecipeDisplay> {
    public static final Function<GTRecipeCategory, CategoryIdentifier<GTRecipeDisplay>> CATEGORIES = Util.m_143827_(c -> CategoryIdentifier.of((ResourceLocation)c.registryKey));
    private final GTRecipeCategory category;
    private final Renderer icon;
    private final Size size;

    public GTRecipeREICategory(@NotNull GTRecipeCategory category) {
        this.category = category;
        GTRecipeType recipeType = category.getRecipeType();
        Size size = recipeType.getRecipeUI().getJEISize();
        this.size = new Size(size.width + 8, size.height + 8);
        this.icon = IGui2Renderer.toDrawable((IGuiTexture)category.getIcon());
    }

    public static void registerDisplays(DisplayRegistry registry) {
        CategoryIdentifier<GTRecipeDisplay> identifier;
        GTRecipeType type;
        ArrayList<GTRecipeCategory> subCategories = new ArrayList<GTRecipeCategory>();
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            if (!category.shouldRegisterDisplays()) continue;
            type = category.getRecipeType();
            if (category != type.getCategory()) {
                subCategories.add(category);
                continue;
            }
            type.buildRepresentativeRecipes();
            identifier = CATEGORIES.apply(category);
            type.getRecipesInCategory(category).stream().map(r -> new GTRecipeDisplay((GTRecipe)r, identifier)).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        }
        for (GTRecipeCategory subCategory : subCategories) {
            if (!subCategory.shouldRegisterDisplays()) continue;
            type = subCategory.getRecipeType();
            identifier = CATEGORIES.apply(subCategory);
            type.getRecipesInCategory(subCategory).stream().map(r -> new GTRecipeDisplay((GTRecipe)r, identifier)).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        }
    }

    public static void registerWorkStations(CategoryRegistry registry) {
        for (MachineDefinition machine : GTRegistries.MACHINES) {
            for (GTRecipeType type : machine.getRecipeTypes()) {
                for (GTRecipeCategory category : type.getCategories()) {
                    if (!category.isXEIVisible() && !GTCEu.isDev()) continue;
                    registry.addWorkstations(GTRecipeREICategory.machineCategory(category), new EntryStack[]{EntryStacks.of((ItemStack)machine.asStack())});
                }
            }
        }
    }

    public static CategoryIdentifier<?> machineCategory(GTRecipeCategory category) {
        if (category == GTRecipeTypes.FURNACE_RECIPES.getCategory()) {
            return BuiltinPlugin.SMELTING;
        }
        return CATEGORIES.apply(category);
    }

    public CategoryIdentifier<? extends GTRecipeDisplay> getCategoryIdentifier() {
        return CATEGORIES.apply(this.category);
    }

    public int getDisplayHeight() {
        return this.getSize().height;
    }

    public int getDisplayWidth(GTRecipeDisplay display) {
        return this.getSize().width;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)this.category.getLanguageKey());
    }

    @Generated
    public Renderer getIcon() {
        return this.icon;
    }

    @Generated
    public Size getSize() {
        return this.size;
    }
}

