/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class SteamBoilerInfoProvider
extends CapabilityInfoProvider<SteamBoilerMachine> {
    @Override
    @Nullable
    protected SteamBoilerMachine getCapability(Level level, BlockPos blockPos, @Nullable Direction side) {
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, blockPos);
        if (metaMachine instanceof SteamBoilerMachine) {
            SteamBoilerMachine steamBoilerMachine = (SteamBoilerMachine)metaMachine;
            return steamBoilerMachine;
        }
        return null;
    }

    @Override
    protected void addProbeInfo(SteamBoilerMachine capability, IProbeInfo probeInfo, Player player, BlockEntity blockEntity, IProbeHitData data) {
        MutableComponent extra;
        boolean makingSteam;
        IProbeInfo horizontalPane = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
        boolean isBurning = capability.getRecipeLogic().isWorking();
        boolean hasWater = !capability.isHasNoWater();
        long production = capability.getTotalSteamOutput();
        int temperature = capability.getCurrentTemperature();
        int maxTemperature = capability.getMaxTemperature();
        boolean bl = makingSteam = hasWater && temperature >= 100;
        MutableComponent root = isBurning && temperature < maxTemperature ? Component.m_237115_((String)"gtceu.machine.boiler.info.heating.up") : (!isBurning && temperature > 0 ? Component.m_237115_((String)"gtceu.machine.boiler.info.cooling.down") : null);
        if (makingSteam) {
            extra = Component.m_237110_((String)"gtceu.machine.boiler.info.production.data", (Object[])new Object[]{Component.m_237113_((String)FormattingUtil.formatNumbers(production / 10L)).m_130940_(ChatFormatting.GREEN)});
            if (root != null) {
                extra = Component.m_237113_((String)" | ").m_7220_((Component)extra);
            }
        } else {
            extra = temperature > 0 && temperature < 100 ? Component.m_237113_((String)String.format(" %s(%s%%)", isBurning ? ChatFormatting.RED : ChatFormatting.BLUE, temperature)) : null;
        }
        if (root != null && extra != null) {
            horizontalPane.text((Component)root.m_7220_(extra));
        } else if (root != null) {
            horizontalPane.text((Component)root);
        } else if (extra != null) {
            horizontalPane.text(extra);
        }
    }

    public ResourceLocation getID() {
        return GTCEu.id("steam_boiler_info");
    }
}

