/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTStringUtils {
    @NotNull
    public static String itemStackToString(@NotNull ItemStack stack) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return stack.m_41613_() + "x_" + itemId.m_135827_() + "_" + itemId.m_135815_();
    }

    @NotNull
    public static String fluidStackToString(@NotNull FluidStack stack) {
        ResourceLocation fluidId = BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid());
        return stack.getAmount() + "x_" + fluidId.m_135827_() + "_" + fluidId.m_135815_();
    }

    @NotNull
    public static String getIntOrderingSuffix(int x) {
        if (x % 100 / 10 == 1) {
            return x + "th";
        }
        if (x % 10 == 1) {
            return x + "st";
        }
        if (x % 10 == 2) {
            return x + "nd";
        }
        if (x % 10 == 3) {
            return x + "rd";
        }
        return x + "th";
    }

    @NotNull
    public static String calc(@NotNull List<String> args) {
        if (args.size() == 3) {
            try {
                long a = Long.parseLong(args.get(0));
                long b = Long.parseLong(args.get(2));
                return switch (args.get(1)) {
                    case "+" -> String.valueOf(a + b);
                    case "-" -> String.valueOf(a - b);
                    case "*" -> String.valueOf(a * b);
                    case "/" -> String.valueOf(a / b);
                    case "%" -> String.valueOf(a % b);
                    case "<<" -> String.valueOf(a << (int)b);
                    case ">>" -> String.valueOf(a >> (int)b);
                    default -> "No such operation: '%s'".formatted(args.get(1));
                };
            }
            catch (NumberFormatException e) {
                try {
                    double a = Double.parseDouble(args.get(0));
                    double b = Double.parseDouble(args.get(2));
                    return switch (args.get(1)) {
                        case "/" -> String.valueOf(a / b);
                        case "+" -> String.valueOf(a + b);
                        case "-" -> String.valueOf(a - b);
                        case "*" -> String.valueOf(a * b);
                        default -> "Invalid number: '%s' or operation '%s'".formatted(e.getMessage(), args.get(1));
                    };
                }
                catch (NumberFormatException ex) {
                    return "Invalid number '%s'!".formatted(ex.getMessage());
                }
            }
        }
        if (args.size() == 2) {
            try {
                long a = Long.parseLong(args.get(1));
                return switch (args.get(0)) {
                    case "~" -> String.valueOf(a ^ 0xFFFFFFFFFFFFFFFFL);
                    case "sqrt" -> String.valueOf(Math.sqrt(a));
                    default -> "No such operation: '%s'".formatted(args.get(0));
                };
            }
            catch (NumberFormatException e) {
                try {
                    double a = Double.parseDouble(args.get(1));
                    return switch (args.get(0)) {
                        case "round" -> String.valueOf(Math.round(a));
                        case "ceil" -> String.valueOf(Math.ceil(a));
                        case "floor" -> String.valueOf(Math.floor(a));
                        case "sqrt" -> String.valueOf(Math.sqrt(a));
                        default -> "Invalid number '%s' or operation '%s'!".formatted(e.getMessage(), args.get(0));
                    };
                }
                catch (NumberFormatException e2) {
                    return "Invalid number '%s'!".formatted(e2.getMessage());
                }
            }
        }
        if (args.size() == 1) {
            return args.get(0);
        }
        return "Invalid expression!";
    }

    public static List<MutableComponent> literalLine(String s) {
        return new ArrayList<MutableComponent>(List.of(Component.m_237113_((String)s)));
    }

    public static List<MutableComponent> literalLine(long n) {
        return GTStringUtils.literalLine(String.valueOf(n));
    }

    public static boolean equals(List<? extends Component> components, String s) {
        return Objects.equals(GTStringUtils.componentsToString(components), s);
    }

    public static double toDouble(List<? extends Component> components) throws NumberFormatException {
        if (components.isEmpty()) {
            return 0.0;
        }
        if (components.size() > 1) {
            throw new NumberFormatException(GTStringUtils.componentsToString(components));
        }
        return Double.parseDouble(components.get(0).getString());
    }

    public static int toInt(List<? extends Component> components) throws NumberFormatException {
        if (components.isEmpty()) {
            return 0;
        }
        if (components.size() > 1) {
            throw new NumberFormatException(GTStringUtils.componentsToString(components));
        }
        return Integer.parseInt(components.get(0).getString());
    }

    public static String componentsToString(List<? extends Component> components) {
        StringBuilder out = new StringBuilder();
        if (components.isEmpty()) {
            return out.toString();
        }
        for (Component component : components) {
            out.append(component.getString());
            out.append('\n');
        }
        return out.substring(0, out.length() - 1);
    }

    public static void append(List<MutableComponent> components, @Nullable String s) {
        if (s != null) {
            GTUtil.getLast(components).m_130946_(s);
        }
    }

    public static void append(List<MutableComponent> components, char c) {
        GTStringUtils.append(components, String.valueOf(c));
    }

    public static void append(List<MutableComponent> components, @Nullable List<? extends Component> lines) {
        if (lines == null) {
            return;
        }
        if (lines.isEmpty()) {
            return;
        }
        for (Component component : lines) {
            GTUtil.getLast(components).m_7220_(component);
            components.add(MutableComponent.m_237204_((ComponentContents)ComponentContents.f_237124_));
        }
        components.remove(components.size() - 1);
    }

    public static List<Component> toImmutable(List<MutableComponent> singleOrMultiLang) {
        return singleOrMultiLang.stream().map(c -> c).toList();
    }

    public static List<MutableComponent> literalLine(double d) {
        return GTStringUtils.literalLine(String.valueOf(d));
    }

    public static String replace(String s, String regex, List<String> replacements) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(s);
        replacements.forEach(replacement -> out.set(0, ((String)out.get(0)).replaceFirst(regex, (String)replacement)));
        return (String)out.get(0);
    }

    public static Component toComponent(ListTag arr) {
        MutableComponent component = Component.m_237113_((String)"[");
        if (arr.size() <= 5) {
            for (int i = 0; i < arr.size(); ++i) {
                component.m_7220_((Component)Component.m_237113_((String)("\"" + arr.m_128778_(i) + "\"")).m_130940_(ChatFormatting.DARK_AQUA));
                if (i == arr.size() - 1) continue;
                component.m_130946_(", ");
            }
        } else {
            int i;
            for (i = 0; i < 2; ++i) {
                component.m_7220_((Component)Component.m_237113_((String)("\"" + arr.m_128778_(i) + "\"")).m_130940_(ChatFormatting.DARK_AQUA));
                component.m_130946_(", ");
            }
            component.m_130946_("..., ");
            for (i = arr.size() - 2; i < arr.size(); ++i) {
                component.m_7220_((Component)Component.m_237113_((String)("\"" + arr.m_128778_(i) + "\"")).m_130940_(ChatFormatting.DARK_AQUA));
                if (i == arr.size() - 1) continue;
                component.m_130946_(", ");
            }
        }
        component.m_130946_("]");
        return component;
    }
}

