/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils.input;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.CPacketKeyDown;
import com.gregtechceu.gtceu.utils.input.IKeyPressedListener;
import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.ApiStatus;

public final class SyncedKeyMapping {
    private static final Int2ObjectMap<SyncedKeyMapping> KEYMAPPINGS = new Int2ObjectOpenHashMap();
    private static int syncIndex = 0;
    @OnlyIn(value=Dist.CLIENT)
    private KeyMapping keyMapping;
    @OnlyIn(value=Dist.CLIENT)
    private Supplier<Supplier<KeyMapping>> keyMappingGetter;
    private final boolean needsRegister;
    @OnlyIn(value=Dist.CLIENT)
    private int keyCode;
    @OnlyIn(value=Dist.CLIENT)
    private boolean isKeyDown;
    private static final Int2BooleanMap updatingKeyDown = new Int2BooleanOpenHashMap();
    private final WeakHashMap<ServerPlayer, Boolean> serverMapping = new WeakHashMap();
    private final WeakHashMap<ServerPlayer, Set<IKeyPressedListener>> playerListeners = new WeakHashMap();
    private final Set<IKeyPressedListener> globalListeners = Collections.newSetFromMap(new WeakHashMap());

    private SyncedKeyMapping(Supplier<Supplier<KeyMapping>> mcKeyMapping) {
        if (GTCEu.isClientSide()) {
            this.keyMappingGetter = mcKeyMapping;
        }
        this.needsRegister = false;
        KEYMAPPINGS.put(syncIndex++, (Object)this);
    }

    private SyncedKeyMapping(int keyCode) {
        if (GTCEu.isClientSide() && !GTCEu.isDataGen()) {
            this.keyCode = keyCode;
        }
        this.needsRegister = false;
        KEYMAPPINGS.put(syncIndex++, (Object)this);
    }

    private SyncedKeyMapping(String nameKey, IKeyConflictContext ctx, int keyCode, String category) {
        if (GTCEu.isClientSide() && !GTCEu.isDataGen()) {
            this.keyMapping = (KeyMapping)this.createKeyMapping(nameKey, ctx, keyCode, category);
        }
        this.needsRegister = true;
        KEYMAPPINGS.put(syncIndex++, (Object)this);
    }

    public static SyncedKeyMapping createFromMC(Supplier<Supplier<KeyMapping>> mcKeyMapping) {
        return new SyncedKeyMapping(mcKeyMapping);
    }

    public static SyncedKeyMapping create(int keyCode) {
        return new SyncedKeyMapping(keyCode);
    }

    public static SyncedKeyMapping createConfigurable(String nameKey, IKeyConflictContext ctx, int keyCode) {
        return SyncedKeyMapping.createConfigurable(nameKey, ctx, keyCode, "GregTechCEu");
    }

    public static SyncedKeyMapping createConfigurable(String nameKey, IKeyConflictContext ctx, int keyCode, String category) {
        return new SyncedKeyMapping(nameKey, ctx, keyCode, category);
    }

    @OnlyIn(value=Dist.CLIENT)
    private Object createKeyMapping(String nameKey, IKeyConflictContext ctx, int keyCode, String category) {
        return new KeyMapping(nameKey, ctx, InputConstants.Type.KEYSYM, keyCode, category);
    }

    public boolean isKeyDown(Player player) {
        if (player.m_9236_().f_46443_) {
            if (this.keyMapping != null) {
                return this.keyMapping.m_90857_();
            }
            long id = Minecraft.m_91087_().m_91268_().m_85439_();
            return InputConstants.m_84830_((long)id, (int)this.keyCode);
        }
        Boolean isKeyDown = this.serverMapping.get((ServerPlayer)player);
        return isKeyDown != null ? isKeyDown : false;
    }

    public SyncedKeyMapping registerPlayerListener(ServerPlayer player, IKeyPressedListener listener) {
        Set listenerSet = this.playerListeners.computeIfAbsent(player, $ -> Collections.newSetFromMap(new WeakHashMap()));
        listenerSet.add(listener);
        return this;
    }

    public static void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        for (SyncedKeyMapping value : KEYMAPPINGS.values()) {
            if (value.keyMappingGetter != null) {
                value.keyMapping = value.keyMappingGetter.get().get();
                value.keyMappingGetter = null;
            }
            if (value.keyMapping == null || !value.needsRegister) continue;
            event.register(value.keyMapping);
        }
    }

    public void removePlayerListener(ServerPlayer player, IKeyPressedListener listener) {
        Set<IKeyPressedListener> listenerSet = this.playerListeners.get(player);
        if (listenerSet != null) {
            listenerSet.remove(listener);
        }
    }

    public SyncedKeyMapping registerGlobalListener(IKeyPressedListener listener) {
        this.globalListeners.add(listener);
        return this;
    }

    public void removeGlobalListener(IKeyPressedListener listener) {
        this.globalListeners.remove(listener);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            updatingKeyDown.clear();
            for (Int2ObjectMap.Entry entry : KEYMAPPINGS.int2ObjectEntrySet()) {
                SyncedKeyMapping keyMapping = (SyncedKeyMapping)entry.getValue();
                boolean previousKeyDown = keyMapping.isKeyDown;
                if (keyMapping.keyMapping != null) {
                    keyMapping.isKeyDown = keyMapping.keyMapping.m_90857_();
                } else {
                    long id = Minecraft.m_91087_().m_91268_().m_85439_();
                    keyMapping.isKeyDown = InputConstants.m_84830_((long)id, (int)keyMapping.keyCode);
                }
                if (previousKeyDown == keyMapping.isKeyDown) continue;
                updatingKeyDown.put(entry.getIntKey(), keyMapping.isKeyDown);
            }
            if (!updatingKeyDown.isEmpty()) {
                GTNetwork.sendToServer(new CPacketKeyDown(updatingKeyDown));
            }
        }
    }

    @ApiStatus.Internal
    public void serverActivate(boolean keyDown, ServerPlayer player) {
        this.serverMapping.put(player, keyDown);
        Set<IKeyPressedListener> listenerSet = this.playerListeners.get(player);
        if (listenerSet != null && !listenerSet.isEmpty()) {
            for (IKeyPressedListener listener : listenerSet) {
                listener.onKeyPressed(player, this, keyDown);
            }
        }
        for (IKeyPressedListener listener : this.globalListeners) {
            listener.onKeyPressed(player, this, keyDown);
        }
    }

    @ApiStatus.Internal
    public static SyncedKeyMapping getFromSyncId(int id) {
        return (SyncedKeyMapping)KEYMAPPINGS.get(id);
    }
}

