/*
 * Decompiled with CFR 0.152.
 */
package me.ljws11.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.ljws11.config.BobblesConfigData;
import net.fabricmc.loader.api.FabricLoader;

public class BobblesConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("bobbles.json");

    public static BobblesConfigData loadConfig() {
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_FILE);
                return (BobblesConfigData)GSON.fromJson(json, BobblesConfigData.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BobblesConfigData defaultConfig = new BobblesConfigData();
        BobblesConfigHandler.saveConfig(defaultConfig);
        return defaultConfig;
    }

    public static void saveConfig(BobblesConfigData config) {
        try {
            String json = GSON.toJson((Object)config);
            Files.writeString(CONFIG_FILE, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

