/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import galena.nirvana.NirvanaConstants;
import galena.nirvana.index.NirvanaItems;
import galena.nirvana.platform.Services;
import galena.nirvana.platform.services.IClientPlatformHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class CustomItemModel {
    private static final IClientPlatformHelper SERVICE = Services.load(IClientPlatformHelper.class);
    public static final CustomItemModel JOINT = SERVICE.registerCustomModel(NirvanaItems.JOINT, List.of(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, ItemDisplayContext.HEAD));
    public static final CustomItemModel DEERSTALKER = SERVICE.registerCustomModel(NirvanaItems.DEERSTALKER, List.of(ItemDisplayContext.HEAD));
    private final ModelResourceLocation equippedModel;
    private final ModelResourceLocation flatModel;
    private final Collection<ItemDisplayContext> contexts;

    public CustomItemModel(String name, Collection<ItemDisplayContext> contexts) {
        this.contexts = contexts;
        ResourceLocation base = NirvanaConstants.createId(name).withPrefix("item/");
        this.equippedModel = new ModelResourceLocation(base.withSuffix("_equipped"), SERVICE.modelVariant());
        this.flatModel = new ModelResourceLocation(base.withSuffix("_flat"), SERVICE.modelVariant());
    }

    public Collection<? extends ModelResourceLocation> models() {
        return List.of(this.flatModel, this.equippedModel);
    }

    private boolean useCustomModel(ItemDisplayContext mode) {
        return this.contexts.contains(mode);
    }

    public void render(ItemStack stack, ItemDisplayContext mode, PoseStack pose, MultiBufferSource vertexConsumers, Renderer r) {
        pose.pushPose();
        boolean customModel = this.useCustomModel(mode);
        ModelResourceLocation texture = customModel ? this.equippedModel : this.flatModel;
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        BakedModel model = renderer.getItemModelShaper().getModelManager().getModel(texture);
        pose.translate(0.5, 0.5, 0.5);
        model.getTransforms().getTransform(mode).apply(false, pose);
        pose.translate(-0.5, -0.5, -0.5);
        RenderType renderType = customModel ? ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)false) : RenderType.cutout();
        VertexConsumer vertex = ItemRenderer.getFoilBufferDirect((MultiBufferSource)vertexConsumers, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil());
        r.render(renderer, model, vertex);
        pose.popPose();
    }

    public static void register() {
    }

    @FunctionalInterface
    public static interface Renderer {
        public void render(ItemRenderer var1, BakedModel var2, VertexConsumer var3);
    }
}

