/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.index;

import galena.nirvana.index.NirvanaItems;
import galena.nirvana.platform.Services;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class NirvanaBrewing {
    private static ItemStack withPotion(ItemLike item, Holder<Potion> potion) {
        ItemStack stack = new ItemStack(item);
        PotionContents contents = new PotionContents(potion);
        stack.set(DataComponents.POTION_CONTENTS, (Object)contents);
        return stack;
    }

    private static boolean isWater(ItemStack stack) {
        return ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER);
    }

    private static void registerMix(PotionBrewing.Builder brewing, ItemStack ingredient, ItemStack from) {
        PotionBrewing vanilla = brewing.build();
        Ingredient input = NirvanaBrewing.isWater(from) ? Ingredient.of((ItemLike[])new ItemLike[]{NirvanaItems.BONG}) : Services.PLATFORM.createNBTIngredient(from);
        ItemStack output = vanilla.mix(ingredient, from);
        if (output == from) {
            return;
        }
        Services.BREWING.addRecipe(brewing, input, Ingredient.of((ItemStack[])new ItemStack[]{ingredient}), output);
    }

    private static void registerBongRecipes(PotionBrewing.Builder builder) {
        PotionBrewing vanilla = builder.build();
        ItemStack waterBottle = NirvanaBrewing.withPotion((ItemLike)Items.POTION, (Holder<Potion>)Potions.WATER);
        Services.BREWING.addRecipe(builder, Services.PLATFORM.createNBTIngredient(waterBottle), Ingredient.of((ItemLike[])new ItemLike[]{NirvanaItems.WEED}), NirvanaItems.BONG.asStack());
        List<ItemStack> catalysts = BuiltInRegistries.ITEM.stream().map(ItemStack::new).filter(arg_0 -> ((PotionBrewing)vanilla).isIngredient(arg_0)).toList();
        BuiltInRegistries.POTION.holders().forEach(potion -> {
            ItemStack from = NirvanaBrewing.withPotion(NirvanaItems.POTION_BONG, (Holder<Potion>)potion);
            ItemStack potionStack = NirvanaBrewing.withPotion((ItemLike)Items.POTION, (Holder<Potion>)potion);
            catalysts.stream().filter(it -> vanilla.hasMix(potionStack, it)).forEach(catalyst -> NirvanaBrewing.registerMix(builder, catalyst, from));
        });
    }

    public static void register(PotionBrewing.Builder builder) {
        NirvanaBrewing.registerBongRecipes(builder);
    }
}

