/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.index;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.EntityEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import galena.nirvana.DistinctBy;
import galena.nirvana.NirvanaClient;
import galena.nirvana.index.NirvanaBlocks;
import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaEntities;
import galena.nirvana.index.NirvanaRecipeTypes;
import galena.nirvana.index.NirvanaSounds;
import galena.nirvana.index.NirvanaTags;
import galena.nirvana.platform.Services;
import galena.nirvana.world.item.BongItem;
import galena.nirvana.world.item.CustomMinecartItem;
import galena.nirvana.world.item.FilledPipeItem;
import galena.nirvana.world.item.HerbalSalveItem;
import galena.nirvana.world.item.JointItem;
import galena.nirvana.world.item.PotionBongItem;
import galena.nirvana.world.item.SuspiciousPipeItem;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;

public class NirvanaItems {
    private static final AbstractRegistrate<?> REGISTRATE = Services.PLATFORM.getRegistrate();
    public static final ItemEntry<Item> HEMP = ((ItemBuilder)REGISTRATE.item("hemp", Item::new).tab(CreativeModeTabs.INGREDIENTS).onRegister(it -> ComposterBlock.COMPOSTABLES.put(it, 0.65f))).register();
    public static final ItemEntry<ItemNameBlockItem> HEMP_SEEDS = ((ItemBuilder)REGISTRATE.item("hemp_seeds", p -> new ItemNameBlockItem((Block)NirvanaBlocks.HEMP.get(), p)).tag(NirvanaTags.SEEDS).tag(new TagKey[]{NirvanaTags.CHICKEN_FOOD}).tag(NirvanaTags.HEMP_SEASONS_ITEMS).tab(CreativeModeTabs.NATURAL_BLOCKS).recipe((c, p) -> p.singleItem(DataIngredient.items((ItemLike)((Item)HEMP.get()), (ItemLike[])new Item[0]), RecipeCategory.MISC, (Supplier)c, 1, 2)).onRegister(it -> ComposterBlock.COMPOSTABLES.put(it, 0.3f))).register();
    public static final ItemEntry<Item> WEED = REGISTRATE.item("weed", Item::new).lang("Weed Bud").tab(CreativeModeTabs.FOOD_AND_DRINKS).recipe((c, p) -> {
        p.smelting(DataIngredient.items((ItemLike)((Item)HEMP.get()), (ItemLike[])new Item[0]), RecipeCategory.MISC, (Supplier)c, 0.25f);
        p.smoking(DataIngredient.items((ItemLike)((Item)HEMP.get()), (ItemLike[])new Item[0]), RecipeCategory.MISC, (Supplier)c, 0.25f);
        p.campfire(DataIngredient.items((ItemLike)((Item)HEMP.get()), (ItemLike[])new Item[0]), RecipeCategory.MISC, (Supplier)c, 0.25f);
    }).register();
    public static final ItemEntry<Item> WEED_BROWNIE = REGISTRATE.item("weed_brownie", Item::new).properties(it -> it.food(NirvanaItems.createBrownieFood())).tab(CreativeModeTabs.FOOD_AND_DRINKS).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)c.get()), (int)2).requires(HEMP_SEEDS).requires((ItemLike)Items.WHEAT).requires((ItemLike)Items.COCOA_BEANS).unlockedBy("has_hemp_seed", RegistrateRecipeProvider.has(HEMP_SEEDS)).save((RecipeOutput)p)).register();
    public static final ItemEntry<BongItem> BONG = REGISTRATE.item("bong", BongItem::new).tab(CreativeModeTabs.FOOD_AND_DRINKS).properties(it -> it.durability(Services.CONFIG.common().getBongHits())).properties(it -> it.craftRemainder(Items.GLASS_BOTTLE)).register();
    public static final ItemEntry<PotionBongItem> POTION_BONG = REGISTRATE.item("potion_bong", PotionBongItem::new).lang("Bong of %s").tab(CreativeModeTabs.FOOD_AND_DRINKS, NirvanaItems.addPotionStacks()).color(() -> () -> NirvanaClient.POTION_COLOR).properties(it -> it.durability(Services.CONFIG.common().getBongHits())).properties(it -> it.craftRemainder(Items.GLASS_BOTTLE)).tag(new TagKey[]{NirvanaTags.SMOKING_ITEM}).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{p.modLoc("item/bong_potion"), p.modLoc("item/bong_potion_overlay")})).register();
    public static final ItemEntry<JointItem> JOINT = REGISTRATE.item("joint", JointItem::new).properties(it -> it.durability(Services.CONFIG.common().getJointHits())).tag(new TagKey[]{NirvanaTags.NAUSEATING}).tag(new TagKey[]{NirvanaTags.SMOKING_ITEM}).tag(new TagKey[]{NirvanaTags.ATTACHED_TO_HEAD}).tab(CreativeModeTabs.FOOD_AND_DRINKS).model(Services.DATAGEN::flatItem).recipe((c, p) -> ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)c.get())).requires((ItemLike)Items.PAPER).requires(WEED).unlockedBy("has_weed", RegistrateRecipeProvider.has(WEED)).save((RecipeOutput)p)).register();
    public static final ItemEntry<HerbalSalveItem> HERBAL_SALVE = REGISTRATE.item("herbal_salve", HerbalSalveItem::new).properties(it -> it.stacksTo(1)).properties(it -> it.craftRemainder(Items.BOWL)).tab(CreativeModeTabs.FOOD_AND_DRINKS, NirvanaItems.addSuspiciousStack(() -> Services.CONFIG.common().herbalSalveFactor())).register();
    public static final ItemEntry<? extends Item> DISC_JAM = ((ItemBuilder)REGISTRATE.item("music_disc_jam", Item::new).properties(it -> it.stacksTo(1)).properties(it -> it.rarity(Rarity.RARE)).properties(it -> it.jukeboxPlayable(NirvanaSounds.JAM_KEY)).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).setData(ProviderType.LANG, (context, provider) -> {
        provider.add((Item)context.get(), "Music Disc");
        provider.add(((Item)context.get()).getDescriptionId() + ".desc", "Jam - firch");
    })).register();
    public static final ItemEntry<? extends Item> EMPTY_PIPE = REGISTRATE.item("old_pipe", Item::new).properties(it -> it.stacksTo(1)).properties(it -> it.rarity(Rarity.UNCOMMON)).model(Services.DATAGEN::pipe).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).register();
    public static final ItemEntry<? extends Item> STUFFED_PIPE = REGISTRATE.item("stuffed_pipe", FilledPipeItem::new).properties(it -> it.durability(Services.CONFIG.common().getPipeHits())).properties(it -> it.rarity(Rarity.UNCOMMON)).properties(it -> it.craftRemainder(EMPTY_PIPE.asItem())).model(Services.DATAGEN::pipe).tag(new TagKey[]{NirvanaTags.SMOKING_ITEM}).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).recipe(Services.DATAGEN::stuffedPipe).register();
    public static final ItemEntry<? extends Item> SUSPICIOUS_PIPE = REGISTRATE.item("suspicious_pipe", SuspiciousPipeItem::new).properties(it -> it.durability(Services.CONFIG.common().getPipeHits())).properties(it -> it.rarity(Rarity.UNCOMMON)).properties(it -> it.craftRemainder(EMPTY_PIPE.asItem())).model(Services.DATAGEN::pipe).tag(new TagKey[]{NirvanaTags.SMOKING_ITEM}).tab(CreativeModeTabs.TOOLS_AND_UTILITIES, NirvanaItems.addSuspiciousStack(() -> Services.CONFIG.common().suspiciousPipeFactor())).register();
    public static final ItemEntry<? extends Item> REEFER_SPAWN_EGG = REGISTRATE.item("reefer_spawn_egg", it -> Services.PLATFORM.createSpawnEggItem((NonNullSupplier<? extends EntityType<? extends Mob>>)NirvanaEntities.REEFER, 6396210, 3100437, (Item.Properties)it)).model((c, p) -> p.withExistingParent(c.getName(), "item/template_spawn_egg")).tab(CreativeModeTabs.SPAWN_EGGS).register();
    public static final ItemEntry<? extends Item> THC_MINECART = ((ItemBuilder)REGISTRATE.item("thc_minecart", it -> new CustomMinecartItem((Item.Properties)it, (EntityEntry<? extends AbstractMinecart>)NirvanaEntities.THC_MINECART)).properties(it -> it.stacksTo(1)).lang("Minecart with THC").recipe(Services.DATAGEN::thcMinecart).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).onRegister(CustomMinecartItem::registerDispenseBehaviour)).register();
    public static final ItemEntry<? extends Item> PEACE_BANNER_PATTERN = ((ItemBuilder)REGISTRATE.item("peace_banner_pattern", it -> new BannerPatternItem(NirvanaTags.PEACE_BANNER_PATTERN, it)).properties(it -> it.stacksTo(1)).properties(it -> it.rarity(Rarity.UNCOMMON)).setData(ProviderType.LANG, (context, provider) -> {
        provider.add((Item)context.get(), "Banner Pattern");
        provider.addTooltip((NonNullSupplier)context, "Peace Sign");
    })).recipe(Services.DATAGEN::peaceBannerPattern).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).register();
    public static final ItemEntry<? extends Item> HEMP_CLOTH = REGISTRATE.item("hemp_cloth", Item::new).recipe((c, p) -> p.square(DataIngredient.items((ItemLike)((Item)HEMP.get()), (ItemLike[])new Item[0]), RecipeCategory.MISC, (Supplier)c, true)).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).register();
    public static final ItemEntry<? extends Item> DEERSTALKER = REGISTRATE.item("deerstalker", Services.PLATFORM::createDeerstalkerItem).properties(it -> it.durability(ArmorItem.Type.HELMET.getDurability(5))).recipe(Services.DATAGEN::deerStalker).model(Services.DATAGEN::flatItem).tab(CreativeModeTabs.TOOLS_AND_UTILITIES).register();
    public static final ItemEntry<? extends Item> REEFER_HEAD = REGISTRATE.item("reefer_head", it -> new StandingAndWallBlockItem((Block)NirvanaBlocks.REEFER_HEAD.get(), (Block)NirvanaBlocks.REEFER_WALL_HEAD.get(), it, Direction.DOWN)).properties(it -> it.rarity(Rarity.UNCOMMON)).model((c, p) -> p.withExistingParent(c.getName(), "item/template_skull")).tab(CreativeModeTabs.FUNCTIONAL_BLOCKS).tag(NirvanaTags.HEADS).register();

    private static FoodProperties createBrownieFood() {
        return new FoodProperties.Builder().effect(new MobEffectInstance(NirvanaEffects.PEACE, 800, 0), 1.0f).nutrition(2).saturationModifier(0.1f).build();
    }

    private static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, CreativeModeTabModifier> addPotionStacks() {
        return (context, modifier) -> BuiltInRegistries.POTION.holders().filter(it -> !it.is(Potions.WATER)).map(it -> {
            ItemStack stack = new ItemStack((ItemLike)context.get());
            stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)it));
            return stack;
        }).forEach(arg_0 -> ((CreativeModeTabModifier)modifier).accept(arg_0));
    }

    private static <T extends Item> NonNullBiConsumer<DataGenContext<Item, T>, CreativeModeTabModifier> addSuspiciousStack(IntSupplier factor) {
        return (context, modifier) -> NirvanaRecipeTypes.getSuspiciousVariants((ItemLike)context.get(), factor.getAsInt()).map(Pair::getSecond).filter(DistinctBy.of(it -> it.get(DataComponents.SUSPICIOUS_STEW_EFFECTS))).forEach(arg_0 -> ((CreativeModeTabModifier)modifier).accept(arg_0));
    }

    public static void register() {
    }
}

