/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world;

import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaParticles;
import galena.nirvana.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class THCCloud {
    public static AreaEffectCloud spawnCloud(Level level, Vec3 at, float size, int nauseaSeconds, int peaceSeconds) {
        level.explode(null, at.x, at.y, at.z, size / 10.0f, Level.ExplosionInteraction.NONE);
        AreaEffectCloud cloud = new AreaEffectCloud(level, at.x, at.y, at.z);
        int amplifier = Services.CONFIG.common().nauseaAfterHits() + 1;
        cloud.addEffect(new MobEffectInstance(NirvanaEffects.PEACE, 20 * peaceSeconds, amplifier));
        cloud.setParticle((ParticleOptions)NirvanaParticles.THC_SMOKE.get());
        cloud.setRadius(1.5f * size);
        cloud.setRadiusPerTick(-0.01f);
        cloud.setDuration(200);
        level.addFreshEntity((Entity)cloud);
        return cloud;
    }

    public static void tickCloud(Level level, BlockPos pos, int range) {
        double z;
        double y;
        double x = (double)((float)pos.getX() + level.getRandom().nextFloat() * (float)range * 2.0f - (float)range) + 0.5;
        BlockPos containing = BlockPos.containing((double)x, (double)(y = (double)((float)pos.getY() + level.getRandom().nextFloat() * (float)range * 2.0f - (float)range) + 0.5), (double)(z = (double)((float)pos.getZ() + level.getRandom().nextFloat() * (float)range * 2.0f - (float)range) + 0.5));
        if (level.getBlockState(containing).isSolid()) {
            return;
        }
        level.addParticle((ParticleOptions)NirvanaParticles.THC_SMOKE.get(), x, y, z, 0.01, 0.01, 0.01);
    }
}

