/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.NirvanaConstants;
import galena.nirvana.index.NirvanaSounds;
import galena.nirvana.platform.Services;
import galena.nirvana.world.item.SmokingItem;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.component.DataComponents;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PotionBongItem
extends SmokingItem {
    public static final String PATTERN_TRANSLATION_KEY = "nirvana.pattern.potion";

    private static MobEffectInstance modify(MobEffectInstance instance) {
        return new MobEffectInstance(instance.getEffect(), instance.getDuration() / Services.CONFIG.common().getBongHits(), instance.getAmplifier(), instance.isAmbient(), instance.isVisible(), instance.showIcon(), null);
    }

    public PotionBongItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    Stream<MobEffectInstance> getEffects(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity) {
        PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (contents == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(contents.getAllEffects().spliterator(), false).map(PotionBongItem::modify);
    }

    @Override
    double getRadius(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity) {
        return Services.CONFIG.common().bongRadius();
    }

    public Component getName(ItemStack stack) {
        if (!Services.CONFIG.common().generateBongTranslations()) {
            return super.getName(stack);
        }
        Language language = Language.getInstance();
        if (language.has(PATTERN_TRANSLATION_KEY)) {
            try {
                String potionTranslation;
                Pattern pattern;
                Matcher matcher;
                Optional potion = Optional.ofNullable((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).flatMap(PotionContents::potion);
                if (potion.isPresent() && (matcher = (pattern = Pattern.compile(language.getOrDefault(PATTERN_TRANSLATION_KEY))).matcher(potionTranslation = language.getOrDefault(Potion.getName(potion, (String)(Items.POTION.getDescriptionId() + ".effect."))))).find()) {
                    String translation = matcher.group(1);
                    return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{translation});
                }
            }
            catch (IllegalStateException | IndexOutOfBoundsException | PatternSyntaxException ex) {
                NirvanaConstants.LOGGER.debug("Unable to translation potion bong automatically", (Throwable)ex);
            }
        }
        return super.getName(stack);
    }

    public String getDescriptionId(ItemStack stack) {
        return Potion.getName((Optional)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion(), (String)(this.getDescriptionId() + ".effect."));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        PotionContents contents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (contents != null) {
            contents.addPotionTooltip(tooltip::add, 1.0f, context.tickRate());
        }
    }

    @Override
    @Nullable
    protected SoundEvent getUseSound() {
        return (SoundEvent)NirvanaSounds.BONG.get();
    }
}

