/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class ThcSmokeParticle
extends TextureSheetParticle {
    public ThcSmokeParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.setAlpha(0.9f);
        this.pickSprite(sprites);
        this.scale(3.0f);
        this.setSize(0.25f, 0.25f);
        this.setLifetime(this.random.nextInt(50) + 100);
        this.yd = (this.random.nextFloat() + 1.0f) / 100.0f;
        this.xd = (this.random.nextFloat() - 0.5f) / 10.0f;
        this.zd = (this.random.nextFloat() - 0.5f) / 10.0f;
        this.yo += (double)level.random.nextFloat() * 1.5;
        this.setPos(x, this.yo, z);
    }

    public void tick() {
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new ThcSmokeParticle(level, x, y, z, this.sprites);
        }
    }
}

