/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.forge.compat;

import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import galena.nirvana.NirvanaConstants;
import galena.nirvana.index.NirvanaItems;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class CreateCompat {
    private static List<RecipeHolder<FillingRecipe>> getBongFillingRecipes(IIngredientManager ingredientManager) {
        Collection items = ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
        Stream<ItemStack> bongs = items.stream().filter(arg_0 -> NirvanaItems.POTION_BONG.isIn(arg_0));
        return bongs.map(stack -> {
            FluidStack potionFluid = PotionFluidHandler.getFluidFromPotionItem((ItemStack)stack);
            ResourceLocation potion = ((ResourceKey)((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion().flatMap(Holder::unwrapKey).orElseThrow()).location();
            ResourceLocation id = NirvanaConstants.createId("fill/bong/" + potion.getNamespace() + "/" + potion.getPath());
            FillingRecipe recipe = (FillingRecipe)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)new StandardProcessingRecipe.Builder(FillingRecipe::new, id).withItemIngredients(new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{NirvanaItems.BONG})})).withFluidIngredients(new FluidIngredient[]{FluidIngredient.fromFluidStack((FluidStack)potionFluid)})).withSingleItemOutput(stack)).build();
            return new RecipeHolder(id, (Recipe)recipe);
        }).toList();
    }

    public static void addJeiRecipes(IRecipeRegistration registration) {
        registration.getJeiHelpers().getRecipeType(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"spout_filling")).map(it -> it).ifPresent(type -> registration.addRecipes(type, CreateCompat.getBongFillingRecipes(registration.getIngredientManager())));
    }
}

