/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import galena.nirvana.client.PeaceShader;
import galena.nirvana.mixins.GameRendererAccessor;
import galena.nirvana.world.effects.PeaceEffect;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Unique
    @Nullable
    private PostChain nirvana$shader = null;
    @Unique
    private boolean nirvana$shaderFailed = false;

    @Unique
    private boolean nirvana$shouldRender() {
        GameRendererAccessor accessor = (GameRendererAccessor)((Object)this);
        if (accessor.getPostEffect() != null) {
            return false;
        }
        return PeaceEffect.shouldRenderShader((Player)accessor.getMinecraft().player);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;doEntityOutline()V")})
    private void renderPeaceShader(DeltaTracker delta, boolean bl, CallbackInfo ci) {
        if (this.nirvana$shaderFailed) {
            return;
        }
        GameRendererAccessor accessor = (GameRendererAccessor)((Object)this);
        Minecraft minecraft = accessor.getMinecraft();
        if (this.nirvana$shouldRender()) {
            if (this.nirvana$shader == null) {
                this.nirvana$shader = PeaceShader.load(minecraft);
                if (this.nirvana$shader == null) {
                    this.nirvana$shaderFailed = true;
                    return;
                }
                this.nirvana$shader.resize(minecraft.getWindow().getWidth(), minecraft.getWindow().getHeight());
            }
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.resetTextureMatrix();
            this.nirvana$shader.process(delta.getGameTimeDeltaTicks());
        } else if (this.nirvana$shader != null) {
            this.nirvana$shader.close();
            this.nirvana$shader = null;
        }
    }

    @Inject(method={"resize"}, at={@At(value="HEAD")})
    private void resizeShader(int width, int height, CallbackInfo ci) {
        if (this.nirvana$shader != null) {
            this.nirvana$shader.resize(width, height);
        }
    }
}

