/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.index.NirvanaParticles;
import galena.nirvana.index.NirvanaSounds;
import galena.nirvana.platform.Services;
import galena.nirvana.world.item.SuspiciousItem;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class HerbalSalveItem
extends SuspiciousStewItem {
    public HerbalSalveItem(Item.Properties properties) {
        super(properties);
    }

    private static List<MobEffectInstance> getEffects(ItemStack stack) {
        return SuspiciousItem.getEffects(stack, 160 * Services.CONFIG.common().herbalSalveFactor());
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            return InteractionResult.PASS;
        }
        List<MobEffectInstance> effects = HerbalSalveItem.getEffects(stack);
        if (effects.isEmpty()) {
            return InteractionResult.PASS;
        }
        effects.forEach(arg_0 -> ((LivingEntity)target).addEffect(arg_0));
        player.playSound((SoundEvent)NirvanaSounds.HERBAL_SALVE.get());
        player.getCooldowns().addCooldown(stack.getItem(), 40);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            float xOffset = target.getBbWidth() / 2.0f;
            float yOffset = target.getBbHeight() / 2.0f;
            level2.sendParticles((ParticleOptions)((SimpleParticleType)NirvanaParticles.HERBAL_SALVE.get()), target.getX() + (double)xOffset, target.getY() + (double)yOffset, target.getZ() + (double)xOffset, 20, (double)xOffset, (double)yOffset, (double)xOffset, 0.05);
        }
        if (!player.getAbilities().instabuild) {
            if (stack.getCount() > 1) {
                stack.shrink(1);
            } else {
                Item remainder = this.getCraftingRemainingItem();
                player.setItemInHand(hand, ItemStack.EMPTY);
                if (remainder != null) {
                    player.addItem(remainder.getDefaultInstance());
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        if (!HerbalSalveItem.getEffects(stack).isEmpty()) {
            return UseAnim.BLOCK;
        }
        return super.getUseAnimation(stack);
    }
}

