/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaSounds;
import galena.nirvana.platform.Services;
import galena.nirvana.world.effects.IStackingEffect;
import galena.nirvana.world.item.SmokingDispenserBehaviour;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class SmokingItem
extends Item {
    public SmokingItem(Item.Properties properties) {
        super(properties);
    }

    protected void registerDispenserBehaviour() {
        SmokingDispenserBehaviour dispenserBehaviour = (source, pos, look, stack) -> {
            this.applyEffects(stack, (Level)source.level(), Vec3.atCenterOf((Vec3i)source.pos()), null);
            Vec3 mouth = pos.add(look.scale(0.5));
            source.level().sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, mouth.x(), mouth.y(), mouth.z(), 5, 0.0, 0.2 + source.level().getRandom().nextDouble() * 0.1, 0.0, 0.02);
        };
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)dispenserBehaviour);
    }

    abstract Stream<MobEffectInstance> getEffects(ItemStack var1, @Nullable Level var2, @Nullable LivingEntity var3);

    abstract double getRadius(ItemStack var1, @Nullable Level var2, @Nullable LivingEntity var3);

    private void addParticles(ServerLevel level, LivingEntity entity) {
        Vec3 rot = entity.getLookAngle().scale(0.6);
        level.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, entity.getX() + rot.x, entity.getEyeY() + rot.y, entity.getZ() + rot.z, 5, 0.0, 0.2 + entity.getRandom().nextDouble() * 0.1, 0.0, 0.02);
    }

    public static void applyEffect(MobEffectInstance instance, ItemStack source, LivingEntity target, @Nullable LivingEntity cause) {
        MobEffectInstance existing = target.getEffect(instance.getEffect());
        Holder effect = instance.getEffect();
        if (existing != null && effect.is(NirvanaEffects.STACKING_EFFECTS)) {
            IStackingEffect stacking;
            Holder holder = instance.getEffect();
            if (holder instanceof IStackingEffect && !(stacking = (IStackingEffect)holder).shouldIncrease(source, target, target.level())) {
                return;
            }
            MobEffectInstance increased = new MobEffectInstance(instance.getEffect(), instance.getDuration(), existing.getAmplifier() + 1, instance.isAmbient(), instance.isVisible(), instance.showIcon(), null);
            target.addEffect(increased);
            Object object = effect.value();
            if (object instanceof IStackingEffect) {
                IStackingEffect stacking2 = (IStackingEffect)object;
                stacking2.onIncreasedTo(increased, source, target, target.level());
            }
        } else if (((MobEffect)effect.value()).isInstantenous()) {
            ((MobEffect)effect.value()).applyInstantenousEffect((Entity)cause, (Entity)cause, target, instance.getAmplifier(), 1.0);
        } else {
            target.addEffect(instance);
        }
    }

    private void applyEffects(ItemStack source, Level level, Vec3 pos, @Nullable LivingEntity user) {
        double range = this.getRadius(source, level, user) * 2.0;
        List targets = level.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)pos, (double)range, (double)range, (double)range));
        targets.forEach(target -> this.getEffects(source, level, user).forEach(effect -> SmokingItem.applyEffect(effect, source, target, user)));
    }

    @Nullable
    protected SoundEvent getUseSound() {
        return (SoundEvent)NirvanaSounds.SMOKING.get();
    }

    public static ItemStack takeHit(Player player, ItemStack stack) {
        player.getCooldowns().addCooldown(stack.getItem(), 20);
        return SmokingItem.takeHit(player.level(), player.position(), SoundSource.PLAYERS, player.getAbilities().instabuild, stack);
    }

    static ItemStack takeHit(Level level, Vec3 pos, SoundSource soundSource, boolean simulate, ItemStack stack) {
        SoundEvent sound;
        Item item = stack.getItem();
        if (item instanceof SmokingItem) {
            SmokingItem item2 = (SmokingItem)item;
            v0 = item2.getUseSound();
        } else {
            v0 = sound = (SoundEvent)NirvanaSounds.SMOKING.get();
        }
        if (sound != null) {
            level.playSound(null, pos.x(), pos.y(), pos.z(), sound, soundSource, 1.0f, 1.0f);
        }
        if (simulate) {
            return stack;
        }
        Item remainder = stack.getItem().getCraftingRemainingItem();
        if (stack.isDamageableItem()) {
            stack.setDamageValue(stack.getDamageValue() + 1);
            if (stack.getDamageValue() == stack.getMaxDamage()) {
                stack.shrink(1);
            }
        } else {
            stack.shrink(1);
        }
        if (stack.isEmpty() && remainder != null) {
            return remainder.getDefaultInstance();
        }
        return stack;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ServerPlayer player;
        entity.gameEvent((Holder)GameEvent.DRINK);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.applyEffects(stack, level, entity.position(), entity);
            this.addParticles(serverLevel, entity);
        }
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(player, stack);
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return SmokingItem.takeHit((Player)player, stack);
        }
        return stack;
    }

    public static InteractionResultHolder<ItemStack> startUsing(Level level, Player player, InteractionHand hand) {
        if (!SmokingItem.canUse((LivingEntity)player)) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public static boolean canUse(LivingEntity entity) {
        return Services.CONFIG.common().allowFakePlayerSmoking() || !Services.PLATFORM.isFakePlayer(entity);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return SmokingItem.startUsing(level, player, hand);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

