/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.index.NirvanaParticles;
import galena.nirvana.platform.Services;
import galena.nirvana.world.item.FilledPipeItem;
import galena.nirvana.world.item.SmokingItem;
import galena.nirvana.world.item.SuspiciousItem;
import java.util.List;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class SuspiciousPipeItem
extends SuspiciousStewItem {
    public SuspiciousPipeItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)FilledPipeItem.DISPENSER_BEHAVIOUR);
    }

    private static List<MobEffectInstance> getEffects(ItemStack stack) {
        return SuspiciousItem.getEffects(stack, 160 * Services.CONFIG.common().suspiciousPipeFactor());
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        if (!SuspiciousPipeItem.getEffects(stack).isEmpty()) {
            return UseAnim.SPYGLASS;
        }
        return super.getUseAnimation(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (SuspiciousPipeItem.getEffects(stack).isEmpty()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        return SmokingItem.startUsing(level, player, hand);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity user) {
        return 32;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        ItemStack itemStack;
        SuspiciousPipeItem.getEffects(stack).forEach(effect -> SmokingItem.applyEffect(effect, stack, user, user));
        NirvanaParticles.spawnRing(level, user);
        if (user instanceof Player) {
            Player player = (Player)user;
            itemStack = SmokingItem.takeHit(player, stack);
        } else {
            itemStack = stack;
        }
        return itemStack;
    }
}

