/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.index;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import galena.nirvana.compat.DyeColors;
import galena.nirvana.index.NirvanaItems;
import galena.nirvana.index.NirvanaTags;
import galena.nirvana.platform.Services;
import galena.nirvana.world.block.CrateBlock;
import galena.nirvana.world.block.HempCropBlock;
import galena.nirvana.world.block.ModdedSkullBlock;
import galena.nirvana.world.block.ModdedWallSkullBlock;
import galena.nirvana.world.block.ThcBlock;
import galena.nirvana.world.block.WildHempBlock;
import galena.nirvana.world.block.entity.ModdedSkullBlockEntity;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class NirvanaBlocks {
    private static final AbstractRegistrate<?> REGISTRATE = Services.PLATFORM.getRegistrate();
    public static final BlockEntry<HempCropBlock> HEMP = REGISTRATE.block("hemp", HempCropBlock::new).initialProperties(() -> Blocks.WHEAT).addLayer(() -> RenderType::cutout).blockstate(Services.DATAGEN::hempCrop).tag(new TagKey[]{BlockTags.CROPS}).tag(NirvanaTags.HEMP_SEASONS_BLOCKS).loot(Services.DATAGEN::hempCrop).register();
    public static final BlockEntry<CrateBlock> HEMP_CRATE = ((BlockBuilder)REGISTRATE.block("hemp_crate", CrateBlock::new).initialProperties(() -> Blocks.BARREL).blockstate(Services.DATAGEN::crate).recipe((c, p) -> p.storage(NirvanaItems.HEMP, RecipeCategory.DECORATIONS, (NonNullSupplier)c)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE}).tag(new TagKey[]{NirvanaTags.SMOKING_CRATES}).item().tab(CreativeModeTabs.BUILDING_BLOCKS).build()).register();
    public static final BlockEntry<CrateBlock> WEED_CRATE = ((BlockBuilder)REGISTRATE.block("weed_crate", CrateBlock::new).initialProperties(() -> Blocks.BARREL).blockstate(Services.DATAGEN::crate).recipe((c, p) -> p.storage(NirvanaItems.WEED, RecipeCategory.DECORATIONS, (NonNullSupplier)c)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE}).tag(new TagKey[]{NirvanaTags.SMOKING_CRATES}).item().tab(CreativeModeTabs.BUILDING_BLOCKS).build()).register();
    public static final BlockEntry<DoublePlantBlock> BLISS_BLOOM = ((BlockBuilder)((ItemBuilder)REGISTRATE.block("bliss_bloom", DoublePlantBlock::new).initialProperties(() -> Blocks.ROSE_BUSH).addLayer(() -> RenderType::cutout).blockstate(Services.DATAGEN::blissBloom).loot(Services.DATAGEN::blissBloom).tag(new TagKey[]{BlockTags.TALL_FLOWERS}).item().tab(CreativeModeTabs.NATURAL_BLOCKS).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{p.modLoc("block/" + c.getName() + "_upper")})).onRegister(it -> ComposterBlock.COMPOSTABLES.put(it, 0.85f))).build()).register();
    public static final BlockEntry<? extends BushBlock> WILD_HEMP = ((BlockBuilder)((ItemBuilder)REGISTRATE.block("wild_hemp", WildHempBlock::new).initialProperties(() -> Blocks.FERN).addLayer(() -> RenderType::cutout).blockstate(Services.DATAGEN::wildHemp).loot(Services.DATAGEN::wildHemp).tag(new TagKey[]{BlockTags.SMALL_FLOWERS}).item().tab(CreativeModeTabs.NATURAL_BLOCKS).model((c, p) -> p.blockSprite((NonNullSupplier)c)).onRegister(it -> ComposterBlock.COMPOSTABLES.put(it, 0.65f))).build()).register();
    public static final BlockEntry<ThcBlock> THC = ((BlockBuilder)REGISTRATE.block("thc", ThcBlock::new).lang("THC").initialProperties(() -> Blocks.TNT).blockstate(Services.DATAGEN::tnt).loot(Services.DATAGEN::tnt).item().tab(CreativeModeTabs.FUNCTIONAL_BLOCKS).recipe(Services.DATAGEN::thc).build()).register();
    public static final SkullBlock.Type REEFER_SKULL_TYPE = () -> "reefer";
    public static final BlockEntry<? extends SkullBlock> REEFER_HEAD = REGISTRATE.block("reefer_head", it -> new ModdedSkullBlock(REEFER_SKULL_TYPE, (BlockBehaviour.Properties)it)).lang("Reefer Head").initialProperties(() -> Blocks.CREEPER_HEAD).blockstate(Services.DATAGEN::skull).register();
    public static final BlockEntry<? extends WallSkullBlock> REEFER_WALL_HEAD = REGISTRATE.block("reefer_wall_head", it -> new ModdedWallSkullBlock(REEFER_SKULL_TYPE, (BlockBehaviour.Properties)it)).lang("Reefer Head").initialProperties(() -> Blocks.CREEPER_WALL_HEAD).blockstate(Services.DATAGEN::skull).register();
    public static final BlockEntityEntry<SkullBlockEntity> MODDED_SKULL = REGISTRATE.blockEntity("skull", ModdedSkullBlockEntity::new).renderer(() -> SkullBlockRenderer::new).validBlocks(new NonNullSupplier[]{REEFER_HEAD, REEFER_WALL_HEAD}).register();
    public static final BlockEntry<FlowerPotBlock> POTTED_WILD_HEMP = REGISTRATE.block("potted_wild_hemp", it -> new FlowerPotBlock((Block)WILD_HEMP.get(), it)).lang("Potted Hemp").initialProperties(() -> Blocks.POTTED_CACTUS).addLayer(() -> RenderType::cutout).blockstate(Services.DATAGEN::pottedPlant).loot(Services.DATAGEN::pottedPlant).register();
    public static final BlockEntry<GlazedTerracottaBlock> HEMP_BURLAP = NirvanaBlocks.createHempBurlap(null);
    public static final Map<DyeColor, BlockEntry<GlazedTerracottaBlock>> COLORED_HEMP_BURLAP = NirvanaBlocks.colored(NirvanaBlocks::createHempBurlap);
    public static final BlockEntry<RotatedPillarBlock> WOVEN_BURLAP = NirvanaBlocks.createWovenBurlap(null);
    public static final Map<DyeColor, BlockEntry<RotatedPillarBlock>> COLORED_WOVEN_BURLAP = NirvanaBlocks.colored(NirvanaBlocks::createWovenBurlap);

    private static BlockEntry<GlazedTerracottaBlock> createHempBurlap(@Nullable DyeColor color) {
        String name = "hemp_burlap";
        String translation = "Burlap";
        return ((BlockBuilder)REGISTRATE.block((String)(color == null ? name : String.valueOf(color) + "_" + name), GlazedTerracottaBlock::new).lang((String)(color == null ? translation : RegistrateLangProvider.toEnglishName((String)color.getSerializedName()) + " " + translation)).initialProperties(() -> Blocks.HAY_BLOCK).properties(it -> it.sound(SoundType.WOOL)).properties(it -> color == null ? it.mapColor(MapColor.WOOL) : it.mapColor(color)).blockstate(Services.DATAGEN::hempBurlap).tag(new TagKey[]{BlockTags.SWORD_EFFICIENT}).item().tab(CreativeModeTabs.BUILDING_BLOCKS).recipe(Services.DATAGEN.hempBurlap(color)).tag(new TagKey[]{NirvanaTags.BURLAP}).build()).register();
    }

    private static BlockEntry<RotatedPillarBlock> createWovenBurlap(@Nullable DyeColor color) {
        String name = "woven_burlap";
        return ((BlockBuilder)REGISTRATE.block((String)(color == null ? name : String.valueOf(color) + "_" + name), RotatedPillarBlock::new).initialProperties(() -> Blocks.HAY_BLOCK).properties(it -> it.sound(SoundType.WOOL)).properties(it -> color == null ? it.mapColor(MapColor.WOOL) : it.mapColor(color)).blockstate(Services.DATAGEN::wovenHempBurlap).tag(new TagKey[]{BlockTags.SWORD_EFFICIENT}).item().tab(CreativeModeTabs.BUILDING_BLOCKS).recipe(Services.DATAGEN.wovenHempBurlap(color)).build()).register();
    }

    private static <T> Map<DyeColor, T> colored(Function<DyeColor, T> mapper) {
        return DyeColors.supported().collect(Collectors.toMap(it -> it, mapper));
    }

    public static void register() {
    }
}

