/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.effects;

import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaEntities;
import galena.nirvana.index.NirvanaTags;
import galena.nirvana.platform.Services;
import galena.nirvana.world.effects.IStackingEffect;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PeaceEffect
extends MobEffect
implements IStackingEffect {
    private static final int REEFER_MIN_RANGE = 8;
    private static final int REEFER_MAX_RANGE = 20;
    private static final int REEFER_CONVERSION_RANGE = 20;
    private static final int REEFER_CONVERSION_RANGE_SQR = 400;

    public PeaceEffect() {
        super(MobEffectCategory.BENEFICIAL, 11190091);
    }

    private static boolean fulfills(int hitsTaken, int hitsRequired) {
        return hitsRequired >= 0 && hitsTaken >= hitsRequired;
    }

    public static boolean shouldRenderShader(@Nullable Player player) {
        if (!Services.CONFIG.client().renderPeaceShader()) {
            return false;
        }
        return Optional.ofNullable(player).map(it -> it.getEffect(NirvanaEffects.PEACE)).filter(it -> PeaceEffect.fulfills(it.getAmplifier(), Services.CONFIG.common().nauseaAfterHits())).isPresent();
    }

    @Override
    public boolean shouldIncrease(ItemStack source, LivingEntity target, Level level) {
        return source.is(NirvanaTags.NAUSEATING);
    }

    @Override
    public void onIncreasedTo(MobEffectInstance instance, ItemStack source, LivingEntity target, Level level) {
        int hitsTaken = instance.getAmplifier() + 1;
        if (PeaceEffect.fulfills(hitsTaken, Services.CONFIG.common().reeferAfterHits())) {
            PeaceEffect.spawnReefers(target, level);
            PeaceEffect.transformCreepers(target.position(), level);
        }
        if (PeaceEffect.fulfills(hitsTaken, Services.CONFIG.common().hungerAfterHits())) {
            target.addEffect(new MobEffectInstance(MobEffects.HUNGER, 400, 2));
        }
    }

    private static void transformCreepers(Vec3 around, Level level) {
        AABB box = new AABB(BlockPos.containing((Position)around)).inflate(21.0);
        List targets = level.getEntitiesOfClass(Creeper.class, box, it -> it.getType().is(NirvanaTags.CREEPER_LIKE) && it.distanceToSqr(around) <= 400.0);
        targets.forEach(it -> {
            Mob replacement = (Mob)NirvanaEntities.REEFER.create(level);
            if (replacement == null) {
                return;
            }
            replacement.setPos(it.position());
            replacement.setYRot(it.getYRot());
            replacement.setXRot(it.getXRot());
            it.remove(Entity.RemovalReason.DISCARDED);
            if (it.isRemoved()) {
                level.addFreshEntity((Entity)replacement);
            }
        });
    }

    private static void spawnReefers(LivingEntity target, Level level) {
        double chance = Services.CONFIG.common().reeferChance();
        if (chance <= 0.0) {
            return;
        }
        int rolls = level.getDifficulty().getId();
        for (int i = 0; i < rolls; ++i) {
            Mob reefer;
            if (!((double)target.getRandom().nextFloat() < chance) || (reefer = (Mob)NirvanaEntities.REEFER.create(level)) == null) continue;
            int rangeAround = 6;
            int centerRange = 8 + rangeAround;
            Vec3 vec = new Vec3(target.getRandom().nextDouble() * 2.0 - 1.0, 0.0, target.getRandom().nextDouble() * 2.0 - 1.0).normalize().scale((double)centerRange);
            Vec3 reference = target.position().add(vec);
            level.findSupportingBlock((Entity)reefer, new AABB(reference, reference).inflate((double)rangeAround)).map(it -> Vec3.upFromBottomCenterOf((Vec3i)it, (double)1.0)).ifPresent(pos -> {
                reefer.setPos(pos);
                level.addFreshEntity((Entity)reefer);
            });
        }
    }

    public void onEffectAdded(LivingEntity entity, int i) {
        super.onEffectAdded(entity, i);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setTarget(null);
        }
    }
}

