/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.particle;

import galena.nirvana.index.NirvanaParticles;
import galena.nirvana.world.particle.ICollidingParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;

public class SmokeRingParticle
extends TextureSheetParticle
implements ICollidingParticle {
    private final SpriteSet sprites;

    protected SmokeRingParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.friction = 0.98f;
        this.setLifetime(160);
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.alpha = 0.9f - (float)this.age * 0.5f / (float)this.lifetime;
    }

    @Override
    public void collide() {
        this.remove();
        this.level.addParticle((ParticleOptions)NirvanaParticles.THC_SMOKE.get(), this.x, this.y, this.z, 0.0, 0.0, 0.0);
    }

    public void setSpriteFromAge(SpriteSet sprites) {
        if (this.removed) {
            return;
        }
        this.setSprite(sprites.get(Math.min((int)(Math.sqrt(this.age) * Math.sqrt(this.lifetime) * 2.0), this.lifetime), this.lifetime));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            SmokeRingParticle particle = new SmokeRingParticle(level, x, y, z, this.sprites);
            particle.xd = xd;
            particle.yd = yd;
            particle.zd = zd;
            return particle;
        }
    }
}

