/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.effects;

import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaEntities;
import galena.nirvana.index.NirvanaTags;
import galena.nirvana.platform.Services;
import galena.nirvana.world.effects.IStackingEffect;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4081;
import org.jetbrains.annotations.Nullable;

public class PeaceEffect
extends class_1291
implements IStackingEffect {
    private static final int REEFER_MIN_RANGE = 8;
    private static final int REEFER_MAX_RANGE = 20;
    private static final int REEFER_CONVERSION_RANGE = 20;
    private static final int REEFER_CONVERSION_RANGE_SQR = 400;

    public PeaceEffect() {
        super(class_4081.field_18271, 11190091);
    }

    private static boolean fulfills(int hitsTaken, int hitsRequired) {
        return hitsRequired >= 0 && hitsTaken >= hitsRequired;
    }

    public static boolean shouldRenderShader(@Nullable class_1657 player) {
        if (!Services.CONFIG.client().renderPeaceShader()) {
            return false;
        }
        return Optional.ofNullable(player).map(it -> it.method_6112(NirvanaEffects.PEACE)).filter(it -> PeaceEffect.fulfills(it.method_5578(), Services.CONFIG.common().nauseaAfterHits())).isPresent();
    }

    @Override
    public boolean shouldIncrease(class_1799 source, class_1309 target, class_1937 level) {
        return source.method_31573(NirvanaTags.NAUSEATING);
    }

    @Override
    public void onIncreasedTo(class_1293 instance, class_1799 source, class_1309 target, class_1937 level) {
        int hitsTaken = instance.method_5578() + 1;
        if (PeaceEffect.fulfills(hitsTaken, Services.CONFIG.common().reeferAfterHits())) {
            PeaceEffect.spawnReefers(target, level);
            PeaceEffect.transformCreepers(target.method_19538(), level);
        }
        if (PeaceEffect.fulfills(hitsTaken, Services.CONFIG.common().hungerAfterHits())) {
            target.method_6092(new class_1293(class_1294.field_5903, 400, 2));
        }
    }

    private static void transformCreepers(class_243 around, class_1937 level) {
        class_238 box = new class_238(class_2338.method_49638((class_2374)around)).method_1014(21.0);
        List targets = level.method_8390(class_1548.class, box, it -> it.method_5864().method_20210(NirvanaTags.CREEPER_LIKE) && it.method_5707(around) <= 400.0);
        targets.forEach(it -> {
            class_1308 replacement = (class_1308)NirvanaEntities.REEFER.create(level);
            if (replacement == null) {
                return;
            }
            replacement.method_33574(it.method_19538());
            replacement.method_36456(it.method_36454());
            replacement.method_36457(it.method_36455());
            it.method_5650(class_1297.class_5529.field_26999);
            if (it.method_31481()) {
                level.method_8649((class_1297)replacement);
            }
        });
    }

    private static void spawnReefers(class_1309 target, class_1937 level) {
        double chance = Services.CONFIG.common().reeferChance();
        if (chance <= 0.0) {
            return;
        }
        int rolls = level.method_8407().method_5461();
        for (int i = 0; i < rolls; ++i) {
            class_1308 reefer;
            if (!((double)target.method_59922().method_43057() < chance) || (reefer = (class_1308)NirvanaEntities.REEFER.create(level)) == null) continue;
            int rangeAround = 6;
            int centerRange = 8 + rangeAround;
            class_243 vec = new class_243(target.method_59922().method_43058() * 2.0 - 1.0, 0.0, target.method_59922().method_43058() * 2.0 - 1.0).method_1029().method_1021((double)centerRange);
            class_243 reference = target.method_19538().method_1019(vec);
            level.method_51718((class_1297)reefer, new class_238(reference, reference).method_1014((double)rangeAround)).map(it -> class_243.method_26410((class_2382)it, (double)1.0)).ifPresent(pos -> {
                reefer.method_33574(pos);
                level.method_8649((class_1297)reefer);
            });
        }
    }

    public void method_58620(class_1309 entity, int i) {
        super.method_58620(entity, i);
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_5980(null);
        }
    }
}

