/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.world.item.ArmorLike;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"})
    public void canAttack(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if (NirvanaEffects.arePeaceful((Entity)self, target)) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapOperation(method={"doHurtEquipment(Lnet/minecraft/world/damagesource/DamageSource;F[Lnet/minecraft/world/entity/EquipmentSlot;)V"}, at={@At(value="INVOKE", target="Ljava/lang/Math;max(FF)F")})
    private float hurtDeerStalker(float a, float b, Operation<Float> original) {
        float amount = Math.max(a, b);
        LivingEntity self = (LivingEntity)this;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = self.getItemBySlot(slot);
            if (!(stack.getItem() instanceof ArmorLike)) continue;
            stack.hurtAndBreak((int)amount, self, slot);
        }
        return amount;
    }
}

