/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import com.tterrag.registrate.util.entry.EntityEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CustomMinecartItem
extends MinecartItem {
    private final NonNullSupplier<EntityType<? extends AbstractMinecart>> entity;
    private final DispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double yOffset;
            RailShape railShape;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = source.level();
            Vec3 center = source.center();
            double x = center.x() + (double)direction.getStepX() * 1.125;
            double y = Math.floor(center.y()) + (double)direction.getStepY();
            double z = center.z() + (double)direction.getStepZ() * 1.125;
            BlockPos pos = source.pos().relative(direction);
            BlockState state = level.getBlockState(pos);
            RailShape railShape2 = railShape = state.getBlock() instanceof BaseRailBlock ? (RailShape)state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            if (state.is(BlockTags.RAILS)) {
                yOffset = railShape.isAscending() ? 0.6 : 0.1;
            } else {
                if (!state.isAir() || !level.getBlockState(pos.below()).is(BlockTags.RAILS)) {
                    return this.defaultBehaviour.dispense(source, stack);
                }
                BlockState belowState = level.getBlockState(pos.below());
                RailShape belowRailShape = belowState.getBlock() instanceof BaseRailBlock ? (RailShape)belowState.getValue(((BaseRailBlock)belowState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
                yOffset = direction != Direction.DOWN && belowRailShape.isAscending() ? -0.4 : -0.9;
            }
            AbstractMinecart minecart = CustomMinecartItem.this.place((Level)level, x, y + yOffset, z);
            if (minecart == null) {
                return stack;
            }
            EntityType.createDefaultStackConfig((ServerLevel)level, (ItemStack)stack, null).accept(minecart);
            level.addFreshEntity((Entity)minecart);
            stack.shrink(1);
            return stack;
        }
    };

    public void registerDispenseBehaviour() {
        DispenserBlock.registerBehavior((ItemLike)this.asItem(), (DispenseItemBehavior)this.dispenseBehavior);
    }

    public CustomMinecartItem(Item.Properties properties, EntityEntry<? extends AbstractMinecart> entity) {
        super(AbstractMinecart.Type.TNT, properties);
        this.entity = () -> entity.get();
    }

    private AbstractMinecart place(Level level, double x, double y, double z) {
        AbstractMinecart minecart = (AbstractMinecart)((EntityType)this.entity.get()).create(level);
        if (minecart == null) {
            return null;
        }
        minecart.setPos(x, y, z);
        minecart.xo = x;
        minecart.yo = y;
        minecart.zo = z;
        return minecart;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (!state.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (level instanceof ServerLevel) {
            RailShape railShape;
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = state.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock rail = (BaseRailBlock)block;
                railShape = (RailShape)state.getValue(rail.getShapeProperty());
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            float yOffset = railshape.isAscending() ? 0.5f : 0.0f;
            AbstractMinecart minecart = this.place(level, (float)pos.getX() + 0.5f, (float)pos.getY() + 0.0625f + yOffset, (float)pos.getZ() + 0.5f);
            if (minecart == null) {
                return InteractionResult.FAIL;
            }
            EntityType.createDefaultStackConfig((ServerLevel)serverLevel, (ItemStack)stack, (Player)context.getPlayer()).accept(minecart);
            level.addFreshEntity((Entity)minecart);
            level.gameEvent((Holder)GameEvent.ENTITY_PLACE, pos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)level.getBlockState(pos.below())));
        }
        stack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

