/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import galena.nirvana.index.NirvanaItems;
import galena.nirvana.index.NirvanaRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.jetbrains.annotations.Nullable;

public class SuspiciousCraftingRecipe
extends CustomRecipe {
    private final ItemStack result;
    public final Ingredient base;
    public final int requiredFlowers;
    public final int requiredWeed;
    public final int durationFactor;

    public SuspiciousCraftingRecipe(CraftingBookCategory category, ItemStack result, Ingredient base, int requiredFlowers, int requiredWeed, int durationFactor) {
        super(category);
        this.result = result;
        this.base = base;
        this.requiredFlowers = requiredFlowers;
        this.requiredWeed = requiredWeed;
        this.durationFactor = durationFactor;
    }

    public ItemStack getContainer() {
        return this.result.copy();
    }

    public boolean matches(CraftingInput input, Level level) {
        @Nullable Item flowerType = null;
        int flowerCount = 0;
        int weedCount = 0;
        boolean hasBase = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (NirvanaItems.WEED.isIn(stack)) {
                ++weedCount;
                continue;
            }
            if (stack.is(ItemTags.SMALL_FLOWERS)) {
                if (flowerType == null) {
                    flowerType = stack.getItem();
                }
                if (stack.is(flowerType)) {
                    ++flowerCount;
                    continue;
                }
                return false;
            }
            if (this.base.test(stack) && !hasBase) {
                hasBase = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return hasBase && weedCount == this.requiredWeed && flowerCount == this.requiredFlowers;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider lookup) {
        ItemStack result = this.getContainer();
        for (int i = 0; i < container.size(); ++i) {
            SuspiciousEffectHolder holder;
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty() || (holder = SuspiciousEffectHolder.tryGet((ItemLike)stack.getItem())) == null) continue;
            SuspiciousStewEffects effects = new SuspiciousStewEffects(holder.getSuspiciousEffects().effects().stream().map(it -> new SuspiciousStewEffects.Entry(it.effect(), it.duration() * this.durationFactor)).toList());
            result.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)effects);
            break;
        }
        return result;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 9;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)NirvanaRecipeTypes.SUSPICIOUS_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<SuspiciousCraftingRecipe> {
        private static final MapCodec<SuspiciousCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)CraftingBookCategory.CODEC.optionalFieldOf("category", (Object)CraftingBookCategory.MISC).forGetter(CustomRecipe::category), (App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("result").forGetter(it -> it.result), (App)Ingredient.CODEC.fieldOf("base").forGetter(it -> it.base), (App)Codec.INT.optionalFieldOf("flowers", (Object)1).forGetter(it -> it.requiredFlowers), (App)Codec.INT.optionalFieldOf("weed", (Object)1).forGetter(it -> it.requiredWeed), (App)Codec.INT.optionalFieldOf("durationFactor", (Object)1).forGetter(it -> it.durationFactor)).apply((Applicative)builder, SuspiciousCraftingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SuspiciousCraftingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CustomRecipe::category, (StreamCodec)ItemStack.STREAM_CODEC, it -> it.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, it -> it.base, (StreamCodec)ByteBufCodecs.INT, it -> it.requiredFlowers, (StreamCodec)ByteBufCodecs.INT, it -> it.requiredWeed, (StreamCodec)ByteBufCodecs.INT, it -> it.durationFactor, SuspiciousCraftingRecipe::new);

        public MapCodec<SuspiciousCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SuspiciousCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

