/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.index;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import galena.nirvana.index.NirvanaItems;
import galena.nirvana.platform.Services;
import galena.nirvana.world.recipe.SuspiciousCraftingRecipe;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.FlowerBlock;

public class NirvanaRecipeTypes {
    private static final AbstractRegistrate<?> REGISTRATE = Services.PLATFORM.getRegistrate();
    public static final RegistryEntry<RecipeSerializer<?>, ? extends RecipeSerializer<?>> SUSPICIOUS_RECIPE_SERIALIZER = REGISTRATE.generic("suspicious_crafting", Registries.RECIPE_SERIALIZER, SuspiciousCraftingRecipe.Serializer::new).register();

    public static Stream<Pair<ItemLike, ItemStack>> getSuspiciousVariants(ItemLike output, int factor) {
        return BuiltInRegistries.ITEM.getTag(ItemTags.SMALL_FLOWERS).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).filter(BlockItem.class::isInstance).map(item -> ((BlockItem)item).getBlock()).filter(FlowerBlock.class::isInstance).map(FlowerBlock.class::cast).map(flower -> {
            ItemStack outputStack = new ItemStack(output);
            List effects = flower.getSuspiciousEffects().effects();
            SuspiciousStewEffects modifiedEffects = new SuspiciousStewEffects(effects.stream().map(it -> new SuspiciousStewEffects.Entry(it.effect(), it.duration() * factor)).toList());
            outputStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)modifiedEffects);
            return new Pair(flower, (Object)outputStack);
        });
    }

    private static Stream<RecipeHolder<CraftingRecipe>> createSuspiciousRecipes(RecipeHolder<SuspiciousCraftingRecipe> from) {
        Ingredient weed = Ingredient.of((ItemLike[])new ItemLike[]{NirvanaItems.WEED});
        return NirvanaRecipeTypes.getSuspiciousVariants((ItemLike)((SuspiciousCraftingRecipe)from.value()).getContainer().getItem(), ((SuspiciousCraftingRecipe)from.value()).durationFactor).map(pair -> {
            int i;
            Item flowerBlock = ((ItemLike)pair.getFirst()).asItem();
            ItemStack output = (ItemStack)pair.getSecond();
            ResourceLocation type = BuiltInRegistries.ITEM.getKey((Object)flowerBlock);
            Ingredient flower = Ingredient.of((ItemLike[])new ItemLike[]{flowerBlock});
            NonNullList inputs = NonNullList.createWithCapacity((int)(((SuspiciousCraftingRecipe)from.value()).requiredFlowers + ((SuspiciousCraftingRecipe)from.value()).requiredWeed + 1));
            for (i = 0; i < ((SuspiciousCraftingRecipe)from.value()).requiredFlowers; ++i) {
                inputs.add((Object)flower);
            }
            for (i = 0; i < ((SuspiciousCraftingRecipe)from.value()).requiredWeed; ++i) {
                inputs.add((Object)weed);
            }
            inputs.add((Object)((SuspiciousCraftingRecipe)from.value()).base);
            ResourceLocation id = from.id().withSuffix("/" + type.getNamespace() + "/" + type.getPath());
            ShapelessRecipe recipe = new ShapelessRecipe(from.id().getPath(), CraftingBookCategory.MISC, output, inputs);
            return new RecipeHolder(id, (Recipe)recipe);
        });
    }

    public static List<RecipeHolder<CraftingRecipe>> createSuspiciousRecipes() {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        return recipeManager.getAllRecipesFor(RecipeType.CRAFTING).stream().filter(it -> it.value() instanceof SuspiciousCraftingRecipe).map(it -> new RecipeHolder(it.id(), (Recipe)((SuspiciousCraftingRecipe)it.value()))).flatMap(NirvanaRecipeTypes::createSuspiciousRecipes).toList();
    }

    public static void register() {
    }
}

