/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.block;

import galena.nirvana.world.block.ICustomTntBlock;
import galena.nirvana.world.entity.PrimedThc;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class ThcBlock
extends TntBlock
implements ICustomTntBlock {
    public ThcBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if (level.isClientSide()) {
            return;
        }
        PrimedThc primed = new PrimedThc(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, igniter);
        level.addFreshEntity((Entity)primed);
        level.playSound(null, primed.getX(), primed.getY(), primed.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)igniter, (Holder)GameEvent.PRIME_FUSE, pos);
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        if (level.isClientSide()) {
            return;
        }
        PrimedThc primed = new PrimedThc(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, explosion.getIndirectSourceEntity());
        int fuse = primed.getFuse();
        primed.setFuse(level.random.nextInt(fuse / 4) + fuse / 8);
        level.addFreshEntity((Entity)primed);
    }
}

