/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.fabric.datagen;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import galena.nirvana.fabric.FabricEntrypoint;
import galena.nirvana.fabric.datagen.AdditionalNirvanaRecipes;
import galena.nirvana.fabric.datagen.DataRegistries;
import galena.nirvana.fabric.datagen.PackMetadataProvider;
import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaItems;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class FabricDataGenerators
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator generator) {
        this.addDefaultTranslations();
        ExistingFileHelper fileHelper = ExistingFileHelper.withResourcesFromArg();
        FabricDataGenerator.Pack pack = generator.createPack();
        FabricEntrypoint.REGISTRATE.setupDatagen(pack, fileHelper);
        pack.addProvider(AdditionalNirvanaRecipes::new);
        pack.addProvider(PackMetadataProvider::new);
        pack.addProvider(DataRegistries::new);
    }

    private void addDefaultTranslations() {
        class_2960 peaceId = NirvanaEffects.PEACE.getId();
        FabricEntrypoint.REGISTRATE.addLang("effect", peaceId, "Peace");
        FabricEntrypoint.REGISTRATE.addLang("effect", peaceId, "description", "A blissful aura befogs your brain");
        FabricEntrypoint.REGISTRATE.addLang("item", NirvanaItems.POTION_BONG.getId(), "effect.empty", "Effect Bong");
        class_7923.field_41179.method_40270().forEach(potion -> {
            String id = potion.method_40237().method_29177().method_12832();
            class_1799 stack = NirvanaItems.POTION_BONG.asStack();
            stack.method_57379(class_9334.field_49651, (Object)new class_1844((class_6880)potion));
            if (((class_1842)potion.comp_349()).method_8049().isEmpty()) {
                FabricEntrypoint.REGISTRATE.addRawLang(stack.method_7922(), RegistrateLangProvider.toEnglishName((String)id) + " Bong");
            } else {
                FabricEntrypoint.REGISTRATE.addRawLang(stack.method_7922(), "Bong of " + RegistrateLangProvider.toEnglishName((String)id));
            }
        });
        this.translatePotion("stunning", "Brain Damage");
    }

    private void translatePotion(String potion) {
        this.translatePotion(potion, RegistrateLangProvider.toEnglishName((String)potion));
    }

    private void translatePotion(String potion, String translation) {
        FabricEntrypoint.REGISTRATE.addRawLang("item.nirvana.potion_bong.effect." + potion, "Bong of " + translation);
    }
}

