/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.index;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import galena.nirvana.index.NirvanaItems;
import galena.nirvana.platform.Services;
import galena.nirvana.world.recipe.SuspicousCraftingRecipe;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.FlowerBlock;

public class NirvanaRecipeTypes {
    private static final AbstractRegistrate<?> REGISTRATE = Services.PLATFORM.getRegistrate();
    public static final RegistryEntry<? extends RecipeSerializer<?>> SUSPICIOUS_RECIPE_SERIALIZER = REGISTRATE.generic("suspicious_crafting", Registries.f_256764_, SuspicousCraftingRecipe.Serializer::new).register();

    public static Stream<Pair<ItemLike, ItemStack>> getSuspiciousVariants(ItemLike output, int factor) {
        return BuiltInRegistries.f_257033_.m_203431_(ItemTags.f_13145_).stream().flatMap(HolderSet.ListBacked::m_203614_).map(Holder::m_203334_).filter(BlockItem.class::isInstance).map(item -> ((BlockItem)item).m_40614_()).filter(FlowerBlock.class::isInstance).map(FlowerBlock.class::cast).map(flower -> {
            ItemStack outputStack = new ItemStack(output);
            MobEffect mobeffect = flower.m_53521_();
            SuspiciousStewItem.m_43258_((ItemStack)outputStack, (MobEffect)mobeffect, (int)(flower.m_53522_() * factor));
            return new Pair(flower, (Object)outputStack);
        });
    }

    private static Stream<CraftingRecipe> createSuspiciousRecipes(Ingredient base, ItemLike result, int flowerCount, int weedCount, int factor) {
        ResourceLocation group = BuiltInRegistries.f_257033_.m_7981_((Object)result.m_5456_());
        Ingredient weed = Ingredient.m_43929_((ItemLike[])new ItemLike[]{NirvanaItems.WEED});
        return NirvanaRecipeTypes.getSuspiciousVariants(result, factor).map(pair -> {
            int i;
            Item flowerBlock = ((ItemLike)pair.getFirst()).m_5456_();
            ItemStack output = (ItemStack)pair.getSecond();
            ResourceLocation type = BuiltInRegistries.f_257033_.m_7981_((Object)flowerBlock);
            Ingredient flower = Ingredient.m_43929_((ItemLike[])new ItemLike[]{flowerBlock});
            NonNullList inputs = NonNullList.m_182647_((int)(flowerCount + weedCount + 1));
            for (i = 0; i < flowerCount; ++i) {
                inputs.add((Object)flower);
            }
            for (i = 0; i < weedCount; ++i) {
                inputs.add((Object)weed);
            }
            inputs.add((Object)base);
            ResourceLocation id = group.m_266382_("/" + type.m_135827_() + "/" + type.m_135815_());
            return new ShapelessRecipe(id, group.toString(), CraftingBookCategory.MISC, output, inputs);
        });
    }

    public static List<CraftingRecipe> createSuspiciousRecipes() {
        return Stream.of(NirvanaRecipeTypes.createSuspiciousRecipes(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42399_}), NirvanaItems.HERBAL_SALVE, 3, 3, Services.CONFIG.common().herbalSalveFactor()), NirvanaRecipeTypes.createSuspiciousRecipes(Ingredient.m_43929_((ItemLike[])new ItemLike[]{NirvanaItems.EMPTY_PIPE}), NirvanaItems.SUSPICIOUS_PIPE, 6, 1, Services.CONFIG.common().suspiciousPipeFactor())).flatMap(Function.identity()).toList();
    }

    public static void register() {
    }
}

