/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.platform.registrate;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BuilderCallback;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public abstract class SoundBuilder<P>
extends AbstractBuilder<SoundEvent, SoundEvent, P, SoundBuilder<P>> {
    @Nullable
    private String subtitleKey;
    private final Set<ResourceLocation> sounds = new HashSet<ResourceLocation>();

    protected SoundBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback) {
        super(owner, parent, name, callback, Registries.f_256840_);
    }

    protected abstract SoundBuilder<P> lang(String var1, String var2);

    public final SoundBuilder<P> with(ResourceLocation ... sounds) {
        this.sounds.addAll(Arrays.asList(sounds));
        return this;
    }

    public final SoundBuilder<P> with(String ... sounds) {
        for (String sound : sounds) {
            this.sounds.add(new ResourceLocation(this.getOwner().getModid(), sound));
        }
        return this;
    }

    public final SoundBuilder<P> lang(String translation) {
        if (this.getSubtitleKey() == null) {
            this.subtitleKey = "subtitle." + this.getName();
        }
        return this.lang(this.getSubtitleKey(), translation);
    }

    @Nullable
    protected final String getSubtitleKey() {
        return this.subtitleKey;
    }

    protected final Stream<ResourceLocation> getSounds() {
        return this.sounds.stream();
    }

    protected final SoundEvent createEntry() {
        if (this.sounds.isEmpty()) {
            throw new IllegalStateException("cannot create SoundEvent without any sounds");
        }
        ResourceLocation id = new ResourceLocation(this.getOwner().getModid(), this.getName());
        return SoundEvent.m_262856_((ResourceLocation)id, (float)1.0f);
    }
}

