/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.index.NirvanaParticles;
import galena.nirvana.platform.Services;
import galena.nirvana.world.item.FilledPipeItem;
import galena.nirvana.world.item.SmokingItem;
import galena.nirvana.world.item.SuspiciousItem;
import java.util.List;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class SuspiciousPipeItem
extends SuspiciousStewItem {
    public SuspiciousPipeItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)FilledPipeItem.DISPENSER_BEHAVIOUR);
    }

    private static List<MobEffectInstance> getEffects(ItemStack stack) {
        return SuspiciousItem.getEffects(stack, 160 * Services.CONFIG.common().suspiciousPipeFactor());
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (!SuspiciousPipeItem.getEffects(stack).isEmpty()) {
            return UseAnim.SPYGLASS;
        }
        return super.m_6164_(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (SuspiciousPipeItem.getEffects(stack).isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return SmokingItem.startUsing(level, player, hand);
    }

    public int m_8105_(ItemStack itemStack) {
        return 32;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        ItemStack itemStack;
        SuspiciousPipeItem.getEffects(stack).forEach(effect -> SmokingItem.applyEffect(effect, stack, user, user));
        NirvanaParticles.spawnRing(level, user);
        if (user instanceof Player) {
            Player player = (Player)user;
            itemStack = SmokingItem.takeHit(player, stack);
        } else {
            itemStack = stack;
        }
        return itemStack;
    }
}

