/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.index;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.util.entry.RegistryEntry;
import galena.nirvana.index.NirvanaItems;
import galena.nirvana.platform.Services;
import galena.nirvana.world.recipe.SuspicousCraftingRecipe;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.FlowerBlock;

public class NirvanaRecipeTypes {
    private static final AbstractRegistrate<?> REGISTRATE = Services.PLATFORM.getRegistrate();
    public static final RegistryEntry<RecipeSerializer<?>, ? extends RecipeSerializer<?>> SUSPICIOUS_RECIPE_SERIALIZER = REGISTRATE.generic("suspicious_crafting", Registries.RECIPE_SERIALIZER, SuspicousCraftingRecipe.Serializer::new).register();

    public static Stream<Pair<ItemLike, ItemStack>> getSuspiciousVariants(ItemLike output, int factor) {
        return BuiltInRegistries.ITEM.getTag(ItemTags.SMALL_FLOWERS).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).filter(BlockItem.class::isInstance).map(item -> ((BlockItem)item).getBlock()).filter(FlowerBlock.class::isInstance).map(FlowerBlock.class::cast).map(flower -> {
            ItemStack outputStack = new ItemStack(output);
            List effects = flower.getSuspiciousEffects().effects();
            SuspiciousStewEffects modifiedEffects = new SuspiciousStewEffects(effects.stream().map(it -> new SuspiciousStewEffects.Entry(it.effect(), it.duration() * factor)).toList());
            outputStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)modifiedEffects);
            return new Pair(flower, (Object)outputStack);
        });
    }

    private static Stream<RecipeHolder<CraftingRecipe>> createSuspiciousRecipes(Ingredient base, ItemLike result, int flowerCount, int weedCount, int factor) {
        ResourceLocation group = BuiltInRegistries.ITEM.getKey((Object)result.asItem());
        Ingredient weed = Ingredient.of((ItemLike[])new ItemLike[]{NirvanaItems.WEED});
        return NirvanaRecipeTypes.getSuspiciousVariants(result, factor).map(pair -> {
            int i;
            Item flowerBlock = ((ItemLike)pair.getFirst()).asItem();
            ItemStack output = (ItemStack)pair.getSecond();
            ResourceLocation type = BuiltInRegistries.ITEM.getKey((Object)flowerBlock);
            Ingredient flower = Ingredient.of((ItemLike[])new ItemLike[]{flowerBlock});
            NonNullList inputs = NonNullList.createWithCapacity((int)(flowerCount + weedCount + 1));
            for (i = 0; i < flowerCount; ++i) {
                inputs.add((Object)flower);
            }
            for (i = 0; i < weedCount; ++i) {
                inputs.add((Object)weed);
            }
            inputs.add((Object)base);
            ResourceLocation id = group.withSuffix("/" + type.getNamespace() + "/" + type.getPath());
            ShapelessRecipe recipe = new ShapelessRecipe(group.toString(), CraftingBookCategory.MISC, output, inputs);
            return new RecipeHolder(id, (Recipe)recipe);
        });
    }

    public static List<RecipeHolder<CraftingRecipe>> createSuspiciousRecipes() {
        return Stream.of(NirvanaRecipeTypes.createSuspiciousRecipes(Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL}), NirvanaItems.HERBAL_SALVE, 3, 3, Services.CONFIG.common().herbalSalveFactor()), NirvanaRecipeTypes.createSuspiciousRecipes(Ingredient.of((ItemLike[])new ItemLike[]{NirvanaItems.EMPTY_PIPE}), NirvanaItems.SUSPICIOUS_PIPE, 6, 1, Services.CONFIG.common().suspiciousPipeFactor())).flatMap(Function.identity()).toList();
    }

    public static void register() {
    }
}

