/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import galena.nirvana.NirvanaConstants;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Cat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Cat.class})
public class CatMixin {
    @Unique
    private static final ResourceLocation SPRIGATITO_TEXTURE = NirvanaConstants.createId("textures/entity/cat/sprigatito.png");

    @Unique
    private boolean nirvana$isSprigatito() {
        Cat self = (Cat)this;
        Component customName = self.getCustomName();
        if (customName == null) {
            return false;
        }
        String name = ChatFormatting.stripFormatting((String)customName.getString()).toLowerCase(Locale.ROOT);
        return name.equals("sprigatito");
    }

    @ModifyReturnValue(method={"getTextureId()Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="RETURN")})
    private ResourceLocation overwriteTexture(ResourceLocation original) {
        if (this.nirvana$isSprigatito()) {
            return SPRIGATITO_TEXTURE;
        }
        return original;
    }
}

