/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaParticles;
import galena.nirvana.platform.Services;
import galena.nirvana.world.item.SmokingDispenserBehaviour;
import galena.nirvana.world.item.SmokingItem;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class FilledPipeItem
extends Item {
    static final SmokingDispenserBehaviour DISPENSER_BEHAVIOUR = (source, pos, look, stack) -> source.level().sendParticles((ParticleOptions)((SimpleParticleType)NirvanaParticles.SMOKE_RING.get()), pos.x, pos.y, pos.z, 0, look.x, look.y, look.z, 0.1);

    public FilledPipeItem(Item.Properties properties) {
        super(properties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOUR);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPYGLASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return SmokingItem.startUsing(level, player, hand);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity user) {
        return 32;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        ItemStack itemStack;
        MobEffectInstance effect = new MobEffectInstance(NirvanaEffects.PEACE, 160 * Services.CONFIG.common().suspiciousPipeFactor(), 0);
        SmokingItem.applyEffect(effect, stack, user, user);
        NirvanaParticles.spawnRing(level, user);
        if (user instanceof Player) {
            Player player = (Player)user;
            itemStack = SmokingItem.takeHit(player, stack);
        } else {
            itemStack = stack;
        }
        return itemStack;
    }
}

