/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import com.tterrag.registrate.util.entry.EntityEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class CustomMinecartItem
extends MinecartItem {
    private final NonNullSupplier<EntityType<? extends AbstractMinecart>> entity;
    private final DispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double yOffset;
            RailShape railShape;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel level = source.m_7727_();
            double x = source.m_7096_() + (double)direction.m_122429_() * 1.125;
            double y = Math.floor(source.m_7098_()) + (double)direction.m_122430_();
            double z = source.m_7094_() + (double)direction.m_122431_() * 1.125;
            BlockPos pos = source.m_7961_().m_121945_(direction);
            BlockState state = level.m_8055_(pos);
            RailShape railShape2 = railShape = state.m_60734_() instanceof BaseRailBlock ? (RailShape)state.m_61143_(((BaseRailBlock)state.m_60734_()).m_7978_()) : RailShape.NORTH_SOUTH;
            if (state.m_204336_(BlockTags.f_13034_)) {
                yOffset = railShape.m_61745_() ? 0.6 : 0.1;
            } else {
                if (!state.m_60795_() || !level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13034_)) {
                    return this.defaultBehaviour.m_6115_(source, stack);
                }
                BlockState belowState = level.m_8055_(pos.m_7495_());
                RailShape belowRailShape = belowState.m_60734_() instanceof BaseRailBlock ? (RailShape)belowState.m_61143_(((BaseRailBlock)belowState.m_60734_()).m_7978_()) : RailShape.NORTH_SOUTH;
                yOffset = direction != Direction.DOWN && belowRailShape.m_61745_() ? -0.4 : -0.9;
            }
            AbstractMinecart minecart = CustomMinecartItem.this.place((Level)level, x, y + yOffset, z);
            if (minecart == null) {
                return stack;
            }
            if (stack.m_41788_()) {
                minecart.m_6593_(stack.m_41786_());
            }
            level.m_7967_((Entity)minecart);
            stack.m_41774_(1);
            return stack;
        }
    };

    public void registerDispenseBehaviour() {
        DispenserBlock.m_52672_((ItemLike)this.m_5456_(), (DispenseItemBehavior)this.dispenseBehavior);
    }

    public CustomMinecartItem(Item.Properties properties, EntityEntry<? extends AbstractMinecart> entity) {
        super(AbstractMinecart.Type.TNT, properties);
        this.entity = () -> entity.get();
    }

    private AbstractMinecart place(Level level, double x, double y, double z) {
        AbstractMinecart minecart = (AbstractMinecart)((EntityType)this.entity.get()).m_20615_(level);
        if (minecart == null) {
            return null;
        }
        minecart.m_6034_(x, y, z);
        minecart.f_19854_ = x;
        minecart.f_19855_ = y;
        minecart.f_19856_ = z;
        return minecart;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        if (!state.m_204336_(BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43722_();
        if (!level.f_46443_) {
            RailShape railShape;
            Block block = state.m_60734_();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock rail = (BaseRailBlock)block;
                railShape = (RailShape)state.m_61143_(rail.m_7978_());
            } else {
                railShape = RailShape.NORTH_SOUTH;
            }
            RailShape railshape = railShape;
            float yOffset = railshape.m_61745_() ? 0.5f : 0.0f;
            AbstractMinecart minecart = this.place(level, (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.0625f + yOffset, (float)pos.m_123343_() + 0.5f);
            if (minecart == null) {
                return InteractionResult.FAIL;
            }
            if (stack.m_41788_()) {
                minecart.m_6593_(stack.m_41786_());
            }
            level.m_7967_((Entity)minecart);
            level.m_220407_(GameEvent.f_157810_, pos, GameEvent.Context.m_223719_((Entity)context.m_43723_(), (BlockState)level.m_8055_(pos.m_7495_())));
        }
        stack.m_41774_(1);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

