/*
 * Decompiled with CFR 0.152.
 */
package net.pawjwp.legumedelight.datagen;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.pawjwp.legumedelight.block.BeanVineBlock;
import net.pawjwp.legumedelight.block.BuddingBeanBlock;
import net.pawjwp.legumedelight.block.LegumeDelightBlocks;
import net.pawjwp.legumedelight.block.PeanutBlock;

public class LegumeDelightBlockStates
extends BlockStateProvider {
    public LegumeDelightBlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "legumedelight", exFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"legumedelight", (String)("block/" + path));
    }

    protected void registerStatesAndModels() {
        this.sackBlock((Block)LegumeDelightBlocks.BEAN_SACK.get(), "bean");
        this.sackBlock((Block)LegumeDelightBlocks.PEANUT_SACK.get(), "peanut");
        this.wildCropBlock((Block)LegumeDelightBlocks.WILD_BEANS.get());
        this.wildCropBlock((Block)LegumeDelightBlocks.WILD_PEANUTS.get());
        this.customStageBlock((Block)LegumeDelightBlocks.BUDDING_BEAN_CROP.get(), ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"block/crop_cross"), "cross", BuddingBeanBlock.AGE, Arrays.asList(0, 1, 2, 3, 3), new Property[0]);
        this.ropeLoggedVineBlock((Block)LegumeDelightBlocks.BEAN_CROP.get(), ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"block/crop_with_rope"), "beans", BeanVineBlock.VINE_AGE, BeanVineBlock.ROPELOGGED, Arrays.asList(0, 1, 2, 3), this.resourceBlock("beans_coiled_rope"), ResourceLocation.parse((String)"farmersdelight:block/rope_top"), new Property[0]);
        this.customStageBlock((Block)LegumeDelightBlocks.PEANUT_CROP.get(), ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"block/crop_cross"), "cross", PeanutBlock.f_52244_, Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7), new Property[0]);
    }

    public void sackBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock(cropName + "_sack_side"), this.resourceBlock(cropName + "_sack_bottom"), this.resourceBlock(cropName + "_sack_top")));
    }

    public void wildCropBlock(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().singleTexture(stageName, parent, textureKey, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void ropeLoggedVineBlock(Block block, @Nullable ResourceLocation parent, String baseName, IntegerProperty ageProperty, BooleanProperty ropeProperty, List<Integer> suffixes, ResourceLocation ropeSideTexture, ResourceLocation ropeTopTexture, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            int suffix = suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size() - 1, ageSuffix));
            boolean rope = (Boolean)state.m_61143_((Property)ropeProperty);
            String textureName = baseName + "_stage" + suffix;
            String modelName = baseName + (rope ? "_vine_stage" : "_stage") + suffix;
            if (rope) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, parent)).texture("crop", this.resourceBlock(textureName))).texture("rope_side", ropeSideTexture)).texture("rope_top", ropeTopTexture)).renderType("cutout")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().singleTexture(textureName, ResourceLocation.parse((String)"farmersdelight:block/crop_cross"), "cross", this.resourceBlock(modelName))).renderType("cutout")).build();
        }, ignored);
    }
}

