/*
 * Decompiled with CFR 0.152.
 */
package net.pawjwp.legumedelight.datagen;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.pawjwp.legumedelight.item.LegumeDelightItems;
import vectorwing.farmersdelight.data.ItemModels;

public class LegumeDelightItemModels
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";

    public LegumeDelightItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "legumedelight", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(i -> "legumedelight".equals(ForgeRegistries.ITEMS.getKey(i).m_135827_())).collect(Collectors.toSet());
        HashSet spriteBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)LegumeDelightItems.BEANS.get(), (Item)LegumeDelightItems.PEANUTS.get()});
        ItemModels.takeAll(items, (Object[])spriteBlockItems.toArray(new Item[0])).forEach(item -> ((ItemModelBuilder)this.withExistingParent(this.itemName((Item)item), GENERATED)).texture("layer0", this.resourceItem(this.itemName((Item)item))));
        HashSet flatBlockItems = Sets.newHashSet((Object[])new Item[]{(Item)LegumeDelightItems.WILD_BEANS.get(), (Item)LegumeDelightItems.WILD_PEANUTS.get()});
        ItemModels.takeAll(items, (Object[])flatBlockItems.toArray(new Item[0])).forEach(item -> this.itemGeneratedModel((Item)item, this.resourceBlock(this.itemName((Item)item))));
        ItemModels.takeAll(items, i -> i instanceof BlockItem).forEach(item -> this.blockBasedModel((Item)item, ""));
        items.forEach(item -> this.itemGeneratedModel((Item)item, this.resourceItem(this.itemName((Item)item))));
    }

    private String itemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    public void blockBasedModel(Item item, String suffix) {
        this.withExistingParent(this.itemName(item), this.resourceBlock(this.itemName(item) + suffix));
    }

    public void itemGeneratedModel(Item item, ResourceLocation texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), GENERATED)).texture("layer0", texture);
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"legumedelight", (String)("block/" + path));
    }

    public ResourceLocation resourceItem(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"legumedelight", (String)("item/" + path));
    }
}

