/*
 * Decompiled with CFR 0.152.
 */
package noisethreader.mixin.vanilla;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.NoiseGeneratorImproved;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import noisethreader.handlers.ForgeConfigHandler;
import noisethreader.handlers.ThreadHandler;
import noisethreader.handlers.VanillaNoiseHandler;
import noisethreader.util.INoiseGeneratorOctaves;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NoiseGeneratorOctaves.class})
public abstract class NoiseGeneratorOctavesMixin
implements INoiseGeneratorOctaves {
    @Shadow
    @Final
    private int field_76306_b;
    @Shadow
    @Final
    private NoiseGeneratorImproved[] field_76307_a;
    @Unique
    private int noisethreader$octaveSplitAmount = 0;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void noisethreader_vanillaNoiseGeneratorOctaves_init(Random seed, int octavesIn, CallbackInfo ci) {
        if (ThreadHandler.getPoolSize() >= ForgeConfigHandler.server.threadPoolMinimumSize) {
            this.noisethreader$octaveSplitAmount = (int)((double)(this.field_76306_b + 1) / 2.0);
        }
    }

    @Overwrite
    public double[] func_76304_a(double[] noiseArray, int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale) {
        if (noiseArray == null) {
            noiseArray = new double[xSize * ySize * zSize];
        } else {
            Arrays.fill(noiseArray, 0.0);
        }
        if (this.noisethreader$octaveSplitAmount <= 0 || this.field_76306_b * xSize * ySize * zSize / this.noisethreader$octaveSplitAmount < 550) {
            return this.noisethreader$generateNoiseOctavesVanilla(noiseArray, xOffset, yOffset, zOffset, xSize, ySize, zSize, xScale, yScale, zScale);
        }
        return VanillaNoiseHandler.generateVanillaNoiseOctaves((NoiseGeneratorOctaves)this, noiseArray, xOffset, yOffset, zOffset, xSize, ySize, zSize, xScale, yScale, zScale, this.field_76306_b, 2, this.noisethreader$octaveSplitAmount);
    }

    @Override
    @Unique
    public double[] noisethreader$generateNoiseOctavesVanilla(double[] noiseArray, int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale) {
        double d3 = 1.0;
        for (int j = 0; j < this.field_76306_b; ++j) {
            double d0 = (double)xOffset * d3 * xScale;
            double d1 = (double)yOffset * d3 * yScale;
            double d2 = (double)zOffset * d3 * zScale;
            long k = MathHelper.func_76124_d((double)d0);
            long l = MathHelper.func_76124_d((double)d2);
            d0 -= (double)k;
            d2 -= (double)l;
            this.field_76307_a[j].func_76308_a(noiseArray, d0 += (double)(k %= 0x1000000L), d1, d2 += (double)(l %= 0x1000000L), xSize, ySize, zSize, xScale * d3, yScale * d3, zScale * d3, d3);
            d3 /= 2.0;
        }
        return noiseArray;
    }

    @Override
    @Unique
    public double[] noisethreader$generateNoiseOctavesThreaded(double[] noiseArray, int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, int octaveStart, int octaveEnd) {
        if (noiseArray == null) {
            noiseArray = new double[xSize * ySize * zSize];
        }
        double d3 = 1.0;
        for (int i = 0; i < octaveStart; ++i) {
            d3 /= 2.0;
        }
        for (int j = octaveStart; j < octaveEnd; ++j) {
            double d0 = (double)xOffset * d3 * xScale;
            double d1 = (double)yOffset * d3 * yScale;
            double d2 = (double)zOffset * d3 * zScale;
            long k = MathHelper.func_76124_d((double)d0);
            long l = MathHelper.func_76124_d((double)d2);
            d0 -= (double)k;
            d2 -= (double)l;
            this.field_76307_a[j].func_76308_a(noiseArray, d0 += (double)(k %= 0x1000000L), d1, d2 += (double)(l %= 0x1000000L), xSize, ySize, zSize, xScale * d3, yScale * d3, zScale * d3, d3);
            d3 /= 2.0;
        }
        return noiseArray;
    }
}

