/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.refabricated.mlconfigs.fabric.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import vectorwing.farmersdelight.refabricated.mlconfigs.ConfigBuilder;
import vectorwing.farmersdelight.refabricated.mlconfigs.fabric.values.ConfigValue;

public class ListStringConfigValue<T extends String>
extends ConfigValue<List<String>> {
    private final Predicate<Object> predicate;

    public ListStringConfigValue(String name, List<String> defaultValue, Predicate<Object> validator) {
        super(name, defaultValue);
        this.predicate = validator;
    }

    @Override
    public boolean isValid(List<String> value) {
        return true;
    }

    @Override
    public void loadFromJson(JsonObject element) {
        if (element.has(this.name)) {
            try {
                JsonElement array = element.get(this.name);
                if (array instanceof JsonArray) {
                    JsonArray ja = (JsonArray)array;
                    this.value = new ArrayList();
                    for (JsonElement v : ja) {
                        String s = v.getAsString();
                        if (!this.predicate.test(s)) continue;
                        ((List)this.value).add(s);
                    }
                }
                if (this.isValid((List)this.value)) {
                    return;
                }
                this.value = this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConfigBuilder.LOGGER.warn("Config file had incorrect entry {}, correcting", (Object)this.name);
        } else {
            ConfigBuilder.LOGGER.warn("Config file had missing entry {}", (Object)this.name);
        }
    }

    @Override
    public void saveToJson(JsonObject object) {
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        JsonArray ja = new JsonArray();
        ((List)this.value).forEach(arg_0 -> ((JsonArray)ja).add(arg_0));
        object.add(this.name, (JsonElement)ja);
    }
}

