/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipeInput;
import vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult;
import vectorwing.farmersdelight.common.registry.ModRecipeBookCategories;
import vectorwing.farmersdelight.common.registry.ModRecipeSerializers;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CuttingBoardRecipe
implements class_1860<CuttingBoardRecipeInput> {
    public static final int MAX_RESULTS = 4;
    private final String group;
    private final class_1856 input;
    private final class_1856 tool;
    private final List<ChanceResult> results;
    @Nullable
    private final class_6880<class_3414> soundEvent;

    public CuttingBoardRecipe(String group, class_1856 input, class_1856 tool, List<ChanceResult> results, @Nullable class_6880<class_3414> soundEvent) {
        this.group = group;
        this.input = input;
        this.tool = tool;
        this.results = results;
        this.soundEvent = soundEvent;
    }

    private CuttingBoardRecipe(String group, class_1856 input, class_1856 tool, List<ChanceResult> results, Optional<class_6880<class_3414>> soundEvent) {
        this(group, input, tool, results, (class_6880<class_3414>)((class_6880)soundEvent.orElse(null)));
    }

    public boolean matches(CuttingBoardRecipeInput input, class_1937 level) {
        return this.input.method_8093(input.item()) && this.tool.method_8093(input.tool());
    }

    public class_1799 assemble(CuttingBoardRecipeInput inv, class_7225.class_7874 provider) {
        return this.results.get(0).stack().method_7972();
    }

    public boolean method_8118() {
        return true;
    }

    public String method_8112() {
        return this.group;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public class_1856 getTool() {
        return this.tool;
    }

    public List<class_1799> getResults() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public List<ChanceResult> getRollableResults() {
        return this.results;
    }

    public List<class_1799> rollResults(class_5819 rand, int fortuneLevel) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        List<ChanceResult> rollableResults = this.getRollableResults();
        for (ChanceResult output : rollableResults) {
            class_1799 stack = output.rollOutput(rand, fortuneLevel);
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        return results;
    }

    public Optional<class_3414> getSoundEvent() {
        return this.getSoundEventHolder().map(class_6880::comp_349);
    }

    public Optional<class_6880<class_3414>> getSoundEventHolder() {
        return Optional.ofNullable(this.soundEvent);
    }

    public class_1865<CuttingBoardRecipe> method_8119() {
        return ModRecipeSerializers.CUTTING.get();
    }

    public class_3956<CuttingBoardRecipe> method_17716() {
        return ModRecipeTypes.CUTTING.get();
    }

    public class_9887 method_61671() {
        return class_9887.field_52597;
    }

    public class_10355 method_64668() {
        return ModRecipeBookCategories.CUTTING.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CuttingBoardRecipe that = (CuttingBoardRecipe)o;
        if (!this.method_8112().equals(that.method_8112())) {
            return false;
        }
        if (!this.input.equals((Object)that.input)) {
            return false;
        }
        if (!this.getTool().equals((Object)that.getTool())) {
            return false;
        }
        if (!this.getResults().equals(that.getResults())) {
            return false;
        }
        return Objects.equals(this.soundEvent, that.soundEvent);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.input, this.tool, this.results, this.soundEvent);
    }

    public static class Serializer
    implements class_1865<CuttingBoardRecipe> {
        public static final class_9139<class_9129, CuttingBoardRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<CuttingBoardRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(CuttingBoardRecipe::method_8112), (App)class_1856.field_46095.listOf(1, 1).fieldOf("ingredients").xmap(List::getFirst, List::of).forGetter(cuttingBoardRecipe -> cuttingBoardRecipe.input), (App)class_1856.field_46095.fieldOf("tool").forGetter(CuttingBoardRecipe::getTool), (App)ChanceResult.CODEC.listOf(1, 4).fieldOf("result").forGetter(CuttingBoardRecipe::getRollableResults), (App)class_3414.field_41699.optionalFieldOf("sound").forGetter(CuttingBoardRecipe::getSoundEventHolder)).apply((Applicative)inst, CuttingBoardRecipe::new));

        public static CuttingBoardRecipe fromNetwork(class_9129 buffer) {
            String groupIn = buffer.method_10800(Short.MAX_VALUE);
            class_1856 inputItemIn = (class_1856)class_1856.field_48355.decode((Object)buffer);
            class_1856 toolIn = (class_1856)class_1856.field_48355.decode((Object)buffer);
            List resultsIn = (List)ChanceResult.STREAM_CODEC.method_56433(class_9135.method_56363()).decode((Object)buffer);
            Optional soundEventIn = (Optional)class_3414.field_48279.method_56433(class_9135::method_56382).decode((Object)buffer);
            return new CuttingBoardRecipe(groupIn, inputItemIn, toolIn, (List<ChanceResult>)resultsIn, (class_6880<class_3414>)((class_6880)soundEventIn.orElse(null)));
        }

        public static void toNetwork(class_9129 buffer, CuttingBoardRecipe recipe) {
            buffer.method_10814(recipe.group);
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.input);
            class_1856.field_48355.encode((Object)buffer, (Object)recipe.tool);
            ChanceResult.STREAM_CODEC.method_56433(class_9135.method_56363()).encode((Object)buffer, recipe.results);
            class_3414.field_48279.method_56433(class_9135::method_56382).encode((Object)buffer, Optional.ofNullable(recipe.soundEvent));
        }

        public MapCodec<CuttingBoardRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CuttingBoardRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

